/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.volumeviz.readers;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec2d;
import com.openinventor.ldm.readers.SoVolumeReader;
import com.openinventor.volumeviz.readers.SoVRSegyFileHeader;
import com.openinventor.volumeviz.readers.SoVRSegyTraceHeaderBytePosition;
import com.openinventor.volumeviz.readers.SoVRSegyTraceIdHeader;

public class SoVRSegyFileReader
extends SoVolumeReader {
    @Deprecated
    public static final int SCAN_CONTINUE = SegyScanningResps.access$000();
    @Deprecated
    public static final int SCAN_ABORT = SegyScanningResps.access$100();
    @Deprecated
    public static final int SEGY_LITTLE_ENDIAN = SegyByteOrders.access$200();
    @Deprecated
    public static final int SEGY_BIG_ENDIAN = SegyByteOrders.access$300();
    @Deprecated
    public static final int XYZ_AS_SAMPLE_INLINE_CROSSLINE = SegyAxisOrders.access$400();
    @Deprecated
    public static final int XYZ_AS_INLINE_CROSSLINE_SAMPLE = SegyAxisOrders.access$500();

    private static native int getSegyByteOrderImpl(long var0);

    private static native void setInlineRangeImpl(long var0, int var2, int var3, int var4);

    private static native boolean setSegyFileHeaderImpl(long var0, long var2);

    private static native int getSegyAxisOrderImpl(long var0);

    private static native String getSegyTextHeaderImpl(long var0);

    private static native void setZRangeImpl(long var0, int var2, int var3, int var4);

    private static native void setSegyByteOrderImpl(long var0, int var2);

    private static native void setCrosslineRangeImpl(long var0, int var2, int var3, int var4);

    private static native void getSegyTraceHeaderBytePositionImpl(long var0, long var2);

    private static native boolean getSegyTraceHeaderImpl(long var0, int var2, long var3);

    private static native int getNumTracesImpl(long var0);

    private static native boolean isSegyRegularImpl(long var0);

    private static native boolean getSegyFileHeaderImpl(long var0, long var2, boolean var4);

    private static native boolean getTraceCoordImpl(long var0, int var2, int var3, double[] var4);

    private static native void setSegyTraceHeaderBytePositionImpl(long var0, long var2);

    private static native long ctorImpl();

    private static native void setVolumeSizeVoxelsImpl(boolean var0);

    private static native void getZRangeImpl(long var0, int[] var2, int[] var3, int[] var4);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoVRSegyFileReader.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native boolean getP1P2P3CoordinatesImpl(long var0, double[] var2, double[] var3, double[] var4, double[] var5);

    private static native void getCrosslineRangeImpl(long var0, int[] var2, int[] var3, int[] var4);

    private static native void setSegyTextHeaderAsciiImpl(long var0, boolean var2);

    private static native void setSegyAxisOrderImpl(long var0, int var2);

    private static native void getInlineRangeImpl(long var0, int[] var2, int[] var3, int[] var4);

    protected SoVRSegyFileReader(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public SoVRSegyFileHeader getSegyFileHeader() {
        return this.getSegyFileHeader(false);
    }

    public String getSegyTextHeader() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoVRSegyFileReader.getSegyTextHeaderImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SegyByteOrders getSegyByteOrder() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SegyByteOrders segyByteOrders = IntegerValuedEnumHelper.fromIntValue(SegyByteOrders.class, SoVRSegyFileReader.getSegyByteOrderImpl(this.getNativeResourceHandle()));
            return segyByteOrders;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSegyByteOrder(SegyByteOrders segyByteOrders) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRSegyFileReader.setSegyByteOrderImpl(this.getNativeResourceHandle(), segyByteOrders.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean setSegyFileHeader(SoVRSegyFileHeader soVRSegyFileHeader) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVRSegyFileReader.setSegyFileHeaderImpl(this.getNativeResourceHandle(), soVRSegyFileHeader != null ? soVRSegyFileHeader.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoVRSegyFileReader() {
        this(Inventor.ConstructorCommand.CreateInstance, SoVRSegyFileReader.ctorImplSync());
    }

    public static void setVolumeSizeVoxels(boolean bl) {
        ObjectManager.globalLock.lock();
        try {
            SoVRSegyFileReader.setVolumeSizeVoxelsImpl(bl);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public void setSegyTextHeaderAscii(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRSegyFileReader.setSegyTextHeaderAsciiImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZRange(int n, int n2, int n3) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRSegyFileReader.setZRangeImpl(this.getNativeResourceHandle(), n, n2, n3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getCrosslineRange() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRSegyFileReader.getCrosslineRangeImpl(this.getNativeResourceHandle(), nArray, nArray2, nArray3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        int[] nArray4 = new int[]{nArray[0], nArray2[0], nArray3[0]};
        return nArray4;
    }

    public SegyAxisOrders getSegyAxisOrder() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SegyAxisOrders segyAxisOrders = IntegerValuedEnumHelper.fromIntValue(SegyAxisOrders.class, SoVRSegyFileReader.getSegyAxisOrderImpl(this.getNativeResourceHandle()));
            return segyAxisOrders;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInlineRange(int n, int n2, int n3) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRSegyFileReader.setInlineRangeImpl(this.getNativeResourceHandle(), n, n2, n3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSegyAxisOrder(SegyAxisOrders segyAxisOrders) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRSegyFileReader.setSegyAxisOrderImpl(this.getNativeResourceHandle(), segyAxisOrders.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec2d[] getP1P2P3Coordinates() {
        SbVec2d sbVec2d = new SbVec2d();
        SbVec2d sbVec2d2 = new SbVec2d();
        SbVec2d sbVec2d3 = new SbVec2d();
        SbVec2d sbVec2d4 = new SbVec2d();
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoVRSegyFileReader.getP1P2P3CoordinatesImpl(this.getNativeResourceHandle(), sbVec2d != null ? sbVec2d.array : null, sbVec2d2 != null ? sbVec2d2.array : null, sbVec2d3 != null ? sbVec2d3.array : null, sbVec2d4 != null ? sbVec2d4.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            SbVec2d[] sbVec2dArray = new SbVec2d[]{sbVec2d, sbVec2d2, sbVec2d3, sbVec2d4};
            return sbVec2dArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getZRange() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRSegyFileReader.getZRangeImpl(this.getNativeResourceHandle(), nArray, nArray2, nArray3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        int[] nArray4 = new int[]{nArray[0], nArray2[0], nArray3[0]};
        return nArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getInlineRange() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRSegyFileReader.getInlineRangeImpl(this.getNativeResourceHandle(), nArray, nArray2, nArray3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        int[] nArray4 = new int[]{nArray[0], nArray2[0], nArray3[0]};
        return nArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec2d getTraceCoord(int n, int n2) {
        SbVec2d sbVec2d = new SbVec2d();
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoVRSegyFileReader.getTraceCoordImpl(this.getNativeResourceHandle(), n, n2, sbVec2d != null ? sbVec2d.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return sbVec2d;
        }
        return null;
    }

    public SoVRSegyTraceHeaderBytePosition getSegyTraceHeaderBytePosition() {
        SoVRSegyTraceHeaderBytePosition soVRSegyTraceHeaderBytePosition = new SoVRSegyTraceHeaderBytePosition();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRSegyFileReader.getSegyTraceHeaderBytePositionImpl(this.getNativeResourceHandle(), soVRSegyTraceHeaderBytePosition.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return soVRSegyTraceHeaderBytePosition;
    }

    public void setSegyTraceHeaderBytePosition(SoVRSegyTraceHeaderBytePosition soVRSegyTraceHeaderBytePosition) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRSegyFileReader.setSegyTraceHeaderBytePositionImpl(this.getNativeResourceHandle(), soVRSegyTraceHeaderBytePosition != null ? soVRSegyTraceHeaderBytePosition.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoVRSegyFileHeader getSegyFileHeader(boolean bl) {
        SoVRSegyFileHeader soVRSegyFileHeader = new SoVRSegyFileHeader();
        boolean bl2 = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl2 = SoVRSegyFileReader.getSegyFileHeaderImpl(this.getNativeResourceHandle(), soVRSegyFileHeader != null ? soVRSegyFileHeader.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl2) {
            return soVRSegyFileHeader;
        }
        return null;
    }

    public int getNumTraces() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRSegyFileReader.getNumTracesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCrosslineRange(int n, int n2, int n3) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRSegyFileReader.setCrosslineRangeImpl(this.getNativeResourceHandle(), n, n2, n3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isSegyRegular() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVRSegyFileReader.isSegyRegularImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoVRSegyTraceIdHeader getSegyTraceHeader(int n) {
        SoVRSegyTraceIdHeader soVRSegyTraceIdHeader = new SoVRSegyTraceIdHeader();
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoVRSegyFileReader.getSegyTraceHeaderImpl(this.getNativeResourceHandle(), n, soVRSegyTraceIdHeader != null ? soVRSegyTraceIdHeader.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return soVRSegyTraceIdHeader;
        }
        return null;
    }

    public static enum SegyAxisOrders implements IntegerValuedEnum
    {
        XYZ_AS_SAMPLE_INLINE_CROSSLINE(SegyAxisOrders.getXYZASSAMPLEINLINECROSSLINE()),
        XYZ_AS_INLINE_CROSSLINE_SAMPLE(SegyAxisOrders.getXYZASINLINECROSSLINESAMPLE());

        private int value;

        private SegyAxisOrders(int n2) {
            this.value = n2;
        }

        private static native int getXYZASINLINECROSSLINESAMPLE();

        private static native int getXYZASSAMPLEINLINECROSSLINE();

        @Deprecated
        public static SegyAxisOrders fromValue(int n) {
            return SegyAxisOrders.valueOf(n);
        }

        public static SegyAxisOrders valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(SegyAxisOrders.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$400() {
            return SegyAxisOrders.getXYZASSAMPLEINLINECROSSLINE();
        }

        static /* synthetic */ int access$500() {
            return SegyAxisOrders.getXYZASINLINECROSSLINESAMPLE();
        }
    }

    public static enum SegyByteOrders implements IntegerValuedEnum
    {
        SEGY_LITTLE_ENDIAN(SegyByteOrders.getSEGYLITTLEENDIAN()),
        SEGY_BIG_ENDIAN(SegyByteOrders.getSEGYBIGENDIAN());

        private int value;

        private SegyByteOrders(int n2) {
            this.value = n2;
        }

        private static native int getSEGYBIGENDIAN();

        private static native int getSEGYLITTLEENDIAN();

        @Deprecated
        public static SegyByteOrders fromValue(int n) {
            return SegyByteOrders.valueOf(n);
        }

        public static SegyByteOrders valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(SegyByteOrders.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$200() {
            return SegyByteOrders.getSEGYLITTLEENDIAN();
        }

        static /* synthetic */ int access$300() {
            return SegyByteOrders.getSEGYBIGENDIAN();
        }
    }

    public static enum SegyScanningResps implements IntegerValuedEnum
    {
        SCAN_CONTINUE(SegyScanningResps.getSCANCONTINUE()),
        SCAN_ABORT(SegyScanningResps.getSCANABORT());

        private int value;

        private SegyScanningResps(int n2) {
            this.value = n2;
        }

        private static native int getSCANABORT();

        private static native int getSCANCONTINUE();

        @Deprecated
        public static SegyScanningResps fromValue(int n) {
            return SegyScanningResps.valueOf(n);
        }

        public static SegyScanningResps valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(SegyScanningResps.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return SegyScanningResps.getSCANCONTINUE();
        }

        static /* synthetic */ int access$100() {
            return SegyScanningResps.getSCANABORT();
        }
    }
}

