/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.volumeviz.readers.dicom;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.volumeviz.readers.dicom.SiDicomElement;
import com.openinventor.volumeviz.readers.dicom.SiDicomValue;
import com.openinventor.volumeviz.readers.dicom.SoDicomTag;

public class SiDicomDataSet
extends Inventor {
    private static native long getElementIntValueImpl(long var0, long var2, long var4, long var6);

    private static native long getElementImpl(long var0, long var2);

    private static native long getElementUIntValueImpl(long var0, long var2, long var4, long var6);

    private static native boolean getElementBufferValueImpl(long var0, long var2, long var4);

    private static native String getElementStringValueImpl(long var0, long var2, long var4, String var6);

    private static native long getElementImpl1(long var0, long var2);

    private static native long cloneImpl(long var0);

    private static native long getElementValueImpl(long var0, long var2);

    private static native long getLengthImpl(long var0);

    private static native double getElementDoubleValueImpl(long var0, long var2, long var4, double var6);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SiDicomDataSet(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getElementDoubleValue(SoDicomTag soDicomTag, long l, double d) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            double d2 = SiDicomDataSet.getElementDoubleValueImpl(this.getNativeResourceHandle(), soDicomTag != null ? soDicomTag.getNativeResourceHandle() : Inventor.ZeroHandle, l, d);
            return d2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SiDicomElement getElement(SoDicomTag soDicomTag) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiDicomElement siDicomElement = ObjectManager.getManagedObjectFor(SiDicomElement.class, SiDicomDataSet.getElementImpl(this.getNativeResourceHandle(), soDicomTag != null ? soDicomTag.getNativeResourceHandle() : Inventor.ZeroHandle));
            return siDicomElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public long getLength() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SiDicomDataSet.getLengthImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getElementBufferValue(SoDicomTag soDicomTag, SoBufferObject soBufferObject) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SiDicomDataSet.getElementBufferValueImpl(this.getNativeResourceHandle(), soDicomTag != null ? soDicomTag.getNativeResourceHandle() : Inventor.ZeroHandle, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SiDicomDataSet clone() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiDicomDataSet siDicomDataSet = ObjectManager.getManagedObjectFor(SiDicomDataSet.class, SiDicomDataSet.cloneImpl(this.getNativeResourceHandle()));
            return siDicomDataSet;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SiDicomValue getElementValue(SoDicomTag soDicomTag) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiDicomValue siDicomValue = ObjectManager.getManagedObjectFor(SiDicomValue.class, SiDicomDataSet.getElementValueImpl(this.getNativeResourceHandle(), soDicomTag != null ? soDicomTag.getNativeResourceHandle() : Inventor.ZeroHandle));
            return siDicomValue;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getElementStringValue(SoDicomTag soDicomTag, long l, String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string2 = SiDicomDataSet.getElementStringValueImpl(this.getNativeResourceHandle(), soDicomTag != null ? soDicomTag.getNativeResourceHandle() : Inventor.ZeroHandle, l, string);
            return string2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getElementIntValue(SoDicomTag soDicomTag, long l, long l2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l3 = SiDicomDataSet.getElementIntValueImpl(this.getNativeResourceHandle(), soDicomTag != null ? soDicomTag.getNativeResourceHandle() : Inventor.ZeroHandle, l, l2);
            return l3;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getElementUIntValue(SoDicomTag soDicomTag, long l, long l2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l3 = SiDicomDataSet.getElementUIntValueImpl(this.getNativeResourceHandle(), soDicomTag != null ? soDicomTag.getNativeResourceHandle() : Inventor.ZeroHandle, l, l2);
            return l3;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SiDicomElement getElement(long l) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiDicomElement siDicomElement = ObjectManager.getManagedObjectFor(SiDicomElement.class, SiDicomDataSet.getElementImpl1(this.getNativeResourceHandle(), l));
            return siDicomElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

