/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.volumeviz.readers.dicom;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.volumeviz.readers.dicom.SiDicomSequence;
import com.openinventor.volumeviz.readers.dicom.SiDicomValue;
import com.openinventor.volumeviz.readers.dicom.SoDicomTag;

public class SiDicomElement
extends Inventor {
    private static native long cloneImpl(long var0);

    private static native long getSequenceImpl(long var0);

    private static native long getValueImpl(long var0);

    private static native void getTagImpl(long var0, long var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SiDicomElement(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SiDicomElement clone() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiDicomElement siDicomElement = ObjectManager.getManagedObjectFor(SiDicomElement.class, SiDicomElement.cloneImpl(this.getNativeResourceHandle()));
            return siDicomElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SiDicomValue getValue() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiDicomValue siDicomValue = ObjectManager.getManagedObjectFor(SiDicomValue.class, SiDicomElement.getValueImpl(this.getNativeResourceHandle()));
            return siDicomValue;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SiDicomSequence getSequence() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiDicomSequence siDicomSequence = ObjectManager.getManagedObjectFor(SiDicomSequence.class, SiDicomElement.getSequenceImpl(this.getNativeResourceHandle()));
            return siDicomSequence;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoDicomTag getTag() {
        SoDicomTag soDicomTag = new SoDicomTag();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiDicomElement.getTagImpl(this.getNativeResourceHandle(), soDicomTag.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return soDicomTag;
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

