/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.volumeviz.readers.dicom;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.volumeviz.readers.dicom.SiDicomDataSet;

public class SiDicomSequence
extends Inventor {
    private static native long getLengthImpl(long var0);

    private static native long cloneImpl(long var0);

    private static native long getItemImpl(long var0, long var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SiDicomSequence(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public long getLength() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SiDicomSequence.getLengthImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SiDicomDataSet getItem(long l) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiDicomDataSet siDicomDataSet = ObjectManager.getManagedObjectFor(SiDicomDataSet.class, SiDicomSequence.getItemImpl(this.getNativeResourceHandle(), l));
            return siDicomDataSet;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SiDicomSequence clone() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiDicomSequence siDicomSequence = ObjectManager.getManagedObjectFor(SiDicomSequence.class, SiDicomSequence.cloneImpl(this.getNativeResourceHandle()));
            return siDicomSequence;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

