/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.volumeviz.readers.dicom;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.devices.SoBufferObject;

public class SiDicomValue
extends Inventor {
    @Deprecated
    public static final int BUFFER = ValueTypes.access$000();
    @Deprecated
    public static final int STRING = ValueTypes.access$100();
    @Deprecated
    public static final int INT = ValueTypes.access$200();
    @Deprecated
    public static final int UINT = ValueTypes.access$300();
    @Deprecated
    public static final int DOUBLE = ValueTypes.access$400();

    private static native String getStringImpl(long var0, long var2);

    private static native void getBufferImpl(long var0, long var2);

    private static native String asStringImpl(long var0);

    private static native long getLengthImpl(long var0);

    private static native long getIntImpl(long var0, long var2);

    private static native double getDoubleImpl(long var0, long var2);

    private static native int getValueTypeImpl(long var0);

    private static native long cloneImpl(long var0);

    private static native long getUIntImpl(long var0, long var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SiDicomValue(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public String getString() {
        return this.getString(0L);
    }

    public long getInt() {
        return this.getInt(0L);
    }

    public double getDouble() {
        return this.getDouble(0L);
    }

    public long getUInt() {
        return this.getUInt(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(long l) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SiDicomValue.getStringImpl(this.getNativeResourceHandle(), l);
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(long l) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            double d = SiDicomValue.getDoubleImpl(this.getNativeResourceHandle(), l);
            return d;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public long getLength() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SiDicomValue.getLengthImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String asString() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SiDicomValue.asStringImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void getBuffer(SoBufferObject soBufferObject) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiDicomValue.getBufferImpl(this.getNativeResourceHandle(), soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getInt(long l) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l2 = SiDicomValue.getIntImpl(this.getNativeResourceHandle(), l);
            return l2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SiDicomValue clone() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiDicomValue siDicomValue = ObjectManager.getManagedObjectFor(SiDicomValue.class, SiDicomValue.cloneImpl(this.getNativeResourceHandle()));
            return siDicomValue;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUInt(long l) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l2 = SiDicomValue.getUIntImpl(this.getNativeResourceHandle(), l);
            return l2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ValueTypes getValueType() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ValueTypes valueTypes = IntegerValuedEnumHelper.fromIntValue(ValueTypes.class, SiDicomValue.getValueTypeImpl(this.getNativeResourceHandle()));
            return valueTypes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static enum ValueTypes implements IntegerValuedEnum
    {
        BUFFER(ValueTypes.getBUFFER()),
        STRING(ValueTypes.getSTRING()),
        INT(ValueTypes.getINT()),
        UINT(ValueTypes.getUINT()),
        DOUBLE(ValueTypes.getDOUBLE());

        private int value;

        private static native int getUINT();

        private static native int getDOUBLE();

        private ValueTypes(int n2) {
            this.value = n2;
        }

        private static native int getBUFFER();

        private static native int getSTRING();

        private static native int getINT();

        @Deprecated
        public static ValueTypes fromValue(int n) {
            return ValueTypes.valueOf(n);
        }

        public static ValueTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ValueTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return ValueTypes.getBUFFER();
        }

        static /* synthetic */ int access$100() {
            return ValueTypes.getSTRING();
        }

        static /* synthetic */ int access$200() {
            return ValueTypes.getINT();
        }

        static /* synthetic */ int access$300() {
            return ValueTypes.getUINT();
        }

        static /* synthetic */ int access$400() {
            return ValueTypes.getDOUBLE();
        }
    }
}

