/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.nodes;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoSFTime;
import com.openinventor.inventor.sensors.SoFieldSensor;
import com.openinventor.inventor.viewercomponents.nodes.AnimatorListener;

abstract class Animator {
    private static final SoSFTime REAL_TIME_FIELD = (SoSFTime)SoDB.getGlobalField((String)"realTime");
    private SoFieldSensor m_animationSensor = new SoFieldSensor();
    private AnimatorListener m_listener = null;

    protected Animator() {
        this.m_animationSensor.setTask(new Runnable(){

            @Override
            public void run() {
                Animator.this.animate();
            }
        });
    }

    protected abstract void animate();

    public void setListener(AnimatorListener animatorListener) {
        this.m_listener = animatorListener;
    }

    public void start() {
        if (this.m_animationSensor.getAttachedField() == null) {
            this.m_animationSensor.attach((SoField)REAL_TIME_FIELD);
            this.m_animationSensor.schedule();
            if (this.m_listener != null) {
                this.m_listener.animationStarted();
            }
        }
    }

    public void stop() {
        if (this.m_animationSensor.getAttachedField() != null) {
            this.m_animationSensor.detach();
            this.m_animationSensor.unschedule();
            if (this.m_listener != null) {
                this.m_listener.animationStopped();
            }
        }
    }
}

