/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.nodes;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.actions.SoHandleEventAction;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.gestures.events.SoDoubleTapGestureEvent;
import com.openinventor.inventor.gestures.events.SoLongTapGestureEvent;
import com.openinventor.inventor.gestures.events.SoRotateGestureEvent;
import com.openinventor.inventor.gestures.events.SoScaleGestureEvent;
import com.openinventor.inventor.misc.callbacks.SoEventCallbackCB;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoDirectionalLight;
import com.openinventor.inventor.nodes.SoEventCallback;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.nodes.SoRotation;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoStereoCamera;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.nodes.SoTransformSeparator;
import com.openinventor.inventor.touch.events.SoTouchEvent;
import com.openinventor.inventor.viewercomponents.SoCameraInteractor;

public class SceneInteractor
extends SoSeparator {
    protected SoCameraInteractor m_cameraInteractor;
    private SoCameraInteractor m_perspInteractor;
    private SoCameraInteractor m_orthoInteractor;
    private KeyboardEventCallbackCB m_keyboardCB;
    private Location2EventCallbackCB m_locationCB;
    private MouseButtonEventCallbackCB m_mouseButtonCB;
    private MouseWheelEventCallbackCB m_mouseWheelCB;
    private TouchEventCallbackCB m_touchCB;
    private ScaleGestureEventCallbackCB m_scaleGestureCB;
    private RotateGestureEventCallbackCB m_rotateGestureCB;
    private DoubleTapGestureEventCallbackCB m_doubleTapGestureCB;
    private LongTapGestureEventCallbackCB m_longTapGestureCB;
    protected SoEventCallback m_eventCallback;
    private SoSwitch m_cameraSwitch;
    private SoSwitch m_headlightSwitch;
    private SoRotation m_headlightRot;

    public SceneInteractor() {
        SoStereoCamera soStereoCamera = new SoStereoCamera();
        this.m_perspInteractor = SoCameraInteractor.getNewInstance((SoCamera)soStereoCamera);
        SoOrthographicCamera soOrthographicCamera = new SoOrthographicCamera();
        this.m_orthoInteractor = SoCameraInteractor.getNewInstance((SoCamera)soOrthographicCamera);
        this.m_cameraSwitch = new SoSwitch();
        this.m_cameraSwitch.addChild((SoNode)soStereoCamera);
        this.m_cameraSwitch.addChild((SoNode)soOrthographicCamera);
        this.m_headlightRot = new SoRotation();
        SoTransformSeparator soTransformSeparator = new SoTransformSeparator();
        soTransformSeparator.addChild((SoNode)this.m_headlightRot);
        soTransformSeparator.addChild((SoNode)new SoDirectionalLight());
        this.m_headlightSwitch = new SoSwitch();
        this.m_headlightSwitch.addChild((SoNode)soTransformSeparator);
        this.m_headlightSwitch.whichChild.setValue(-3);
        this.m_cameraInteractor = null;
        this.setCameraMode(CameraMode.PERSPECTIVE);
        this.m_eventCallback = new SoEventCallback();
        this.m_keyboardCB = new KeyboardEventCallbackCB();
        this.m_locationCB = new Location2EventCallbackCB();
        this.m_mouseButtonCB = new MouseButtonEventCallbackCB();
        this.m_mouseWheelCB = new MouseWheelEventCallbackCB();
        this.m_touchCB = new TouchEventCallbackCB();
        this.m_scaleGestureCB = new ScaleGestureEventCallbackCB();
        this.m_rotateGestureCB = new RotateGestureEventCallbackCB();
        this.m_doubleTapGestureCB = new DoubleTapGestureEventCallbackCB();
        this.m_longTapGestureCB = new LongTapGestureEventCallbackCB();
        this.m_eventCallback.addEventCallback(SoKeyboardEvent.class, (SoEventCallbackCB)this.m_keyboardCB);
        this.m_eventCallback.addEventCallback(SoLocation2Event.class, (SoEventCallbackCB)this.m_locationCB);
        this.m_eventCallback.addEventCallback(SoMouseButtonEvent.class, (SoEventCallbackCB)this.m_mouseButtonCB);
        this.m_eventCallback.addEventCallback(SoMouseWheelEvent.class, (SoEventCallbackCB)this.m_mouseWheelCB);
        this.m_eventCallback.addEventCallback(SoTouchEvent.class, (SoEventCallbackCB)this.m_touchCB);
        this.m_eventCallback.addEventCallback(SoScaleGestureEvent.class, (SoEventCallbackCB)this.m_scaleGestureCB);
        this.m_eventCallback.addEventCallback(SoRotateGestureEvent.class, (SoEventCallbackCB)this.m_rotateGestureCB);
        this.m_eventCallback.addEventCallback(SoDoubleTapGestureEvent.class, (SoEventCallbackCB)this.m_doubleTapGestureCB);
        this.m_eventCallback.addEventCallback(SoLongTapGestureEvent.class, (SoEventCallbackCB)this.m_longTapGestureCB);
        this.addChild((SoNode)this.m_eventCallback);
        this.addChild((SoNode)this.m_cameraSwitch);
        this.addChild((SoNode)this.m_headlightSwitch);
    }

    public boolean dispose() {
        this.m_keyboardCB.dispose();
        this.m_locationCB.dispose();
        this.m_mouseButtonCB.dispose();
        this.m_mouseWheelCB.dispose();
        this.m_touchCB.dispose();
        this.m_scaleGestureCB.dispose();
        this.m_rotateGestureCB.dispose();
        this.m_doubleTapGestureCB.dispose();
        this.m_longTapGestureCB.dispose();
        return super.dispose();
    }

    public void setCameraMode(CameraMode cameraMode) {
        if (cameraMode == CameraMode.PERSPECTIVE) {
            if (this.m_cameraInteractor != null) {
                this.m_perspInteractor.synchronize(this.m_cameraInteractor.getCamera());
            }
            this.m_cameraInteractor = this.m_perspInteractor;
            this.m_cameraSwitch.whichChild.setValue(0);
        } else if (cameraMode == CameraMode.ORTHOGRAPHIC) {
            if (this.m_cameraInteractor != null) {
                this.m_orthoInteractor.synchronize(this.m_cameraInteractor.getCamera());
            }
            this.m_cameraInteractor = this.m_orthoInteractor;
            this.m_cameraSwitch.whichChild.setValue(1);
        }
        this.m_headlightRot.rotation.connectFrom((SoField)this.m_cameraInteractor.getCamera().orientation);
    }

    public CameraMode getCameraMode() {
        int n = this.m_cameraSwitch.whichChild.getValue();
        if (n == 0) {
            return CameraMode.PERSPECTIVE;
        }
        return CameraMode.ORTHOGRAPHIC;
    }

    public SoCameraInteractor getCameraInteractor() {
        return this.m_cameraInteractor;
    }

    public SoCamera getCamera() {
        return this.m_cameraInteractor.getCamera();
    }

    public void adjustClippingPlanes(SbViewportRegion sbViewportRegion) {
        this.m_cameraInteractor.adjustClippingPlanes((SoNode)this, sbViewportRegion);
    }

    public void viewAll(SbViewportRegion sbViewportRegion) {
        this.m_cameraInteractor.viewAll((SoNode)this, sbViewportRegion);
    }

    public void viewAxis(SbVec3f sbVec3f, SbVec3f sbVec3f2) {
        this.m_cameraInteractor.viewAxis(sbVec3f, sbVec3f2);
    }

    public void enableHeadlight(boolean bl) {
        if (bl) {
            this.m_headlightSwitch.whichChild.setValue(-3);
        } else {
            this.m_headlightSwitch.whichChild.setValue(-1);
        }
    }

    public boolean isHeadlightEnabled() {
        return this.m_headlightSwitch.whichChild.getValue() == -3;
    }

    protected void keyPressed(SoKeyboardEvent soKeyboardEvent, SoHandleEventAction soHandleEventAction) {
    }

    protected void keyReleased(SoKeyboardEvent soKeyboardEvent, SoHandleEventAction soHandleEventAction) {
    }

    protected void mousePressed(SoMouseButtonEvent soMouseButtonEvent, SoHandleEventAction soHandleEventAction) {
    }

    protected void mouseReleased(SoMouseButtonEvent soMouseButtonEvent, SoHandleEventAction soHandleEventAction) {
    }

    protected void mouseWheelMoved(SoMouseWheelEvent soMouseWheelEvent, SoHandleEventAction soHandleEventAction) {
    }

    protected void mouseMoved(SoLocation2Event soLocation2Event, SoHandleEventAction soHandleEventAction) {
    }

    protected void touch(SoTouchEvent soTouchEvent, SoHandleEventAction soHandleEventAction) {
    }

    protected void zoom(SoScaleGestureEvent soScaleGestureEvent, SoHandleEventAction soHandleEventAction) {
    }

    protected void rotate(SoRotateGestureEvent soRotateGestureEvent, SoHandleEventAction soHandleEventAction) {
    }

    protected void doubleTap(SoDoubleTapGestureEvent soDoubleTapGestureEvent, SoHandleEventAction soHandleEventAction) {
    }

    protected void longTap(SoLongTapGestureEvent soLongTapGestureEvent, SoHandleEventAction soHandleEventAction) {
    }

    private class LongTapGestureEventCallbackCB
    extends SoEventCallbackCB {
        private LongTapGestureEventCallbackCB() {
        }

        public void invoke(SoEventCallback soEventCallback) {
            SoEvent soEvent = soEventCallback.getEvent();
            if (soEvent != null) {
                SceneInteractor.this.longTap((SoLongTapGestureEvent)soEvent, soEventCallback.getAction());
            }
        }
    }

    private class DoubleTapGestureEventCallbackCB
    extends SoEventCallbackCB {
        private DoubleTapGestureEventCallbackCB() {
        }

        public void invoke(SoEventCallback soEventCallback) {
            SoEvent soEvent = soEventCallback.getEvent();
            if (soEvent != null) {
                SceneInteractor.this.doubleTap((SoDoubleTapGestureEvent)soEvent, soEventCallback.getAction());
            }
        }
    }

    private class RotateGestureEventCallbackCB
    extends SoEventCallbackCB {
        private RotateGestureEventCallbackCB() {
        }

        public void invoke(SoEventCallback soEventCallback) {
            SoEvent soEvent = soEventCallback.getEvent();
            if (soEvent != null) {
                SceneInteractor.this.rotate((SoRotateGestureEvent)soEvent, soEventCallback.getAction());
            }
        }
    }

    private class ScaleGestureEventCallbackCB
    extends SoEventCallbackCB {
        private ScaleGestureEventCallbackCB() {
        }

        public void invoke(SoEventCallback soEventCallback) {
            SoEvent soEvent = soEventCallback.getEvent();
            if (soEvent != null) {
                SceneInteractor.this.zoom((SoScaleGestureEvent)soEvent, soEventCallback.getAction());
            }
        }
    }

    private class TouchEventCallbackCB
    extends SoEventCallbackCB {
        private TouchEventCallbackCB() {
        }

        public void invoke(SoEventCallback soEventCallback) {
            SoEvent soEvent = soEventCallback.getEvent();
            if (soEvent != null) {
                SceneInteractor.this.touch((SoTouchEvent)soEvent, soEventCallback.getAction());
            }
        }
    }

    private class Location2EventCallbackCB
    extends SoEventCallbackCB {
        private Location2EventCallbackCB() {
        }

        public void invoke(SoEventCallback soEventCallback) {
            SoEvent soEvent = soEventCallback.getEvent();
            if (soEvent != null) {
                SceneInteractor.this.mouseMoved((SoLocation2Event)soEvent, soEventCallback.getAction());
            }
        }
    }

    private class MouseWheelEventCallbackCB
    extends SoEventCallbackCB {
        private MouseWheelEventCallbackCB() {
        }

        public void invoke(SoEventCallback soEventCallback) {
            SoEvent soEvent = soEventCallback.getEvent();
            if (soEvent != null) {
                SceneInteractor.this.mouseWheelMoved((SoMouseWheelEvent)soEvent, soEventCallback.getAction());
            }
        }
    }

    private class MouseButtonEventCallbackCB
    extends SoEventCallbackCB {
        private MouseButtonEventCallbackCB() {
        }

        public void invoke(SoEventCallback soEventCallback) {
            SoEvent soEvent = soEventCallback.getEvent();
            if (soEvent != null) {
                if (SoMouseButtonEvent.isButtonPressEvent((SoEvent)soEvent, (SoMouseButtonEvent.Buttons)SoMouseButtonEvent.Buttons.ANY)) {
                    SceneInteractor.this.mousePressed((SoMouseButtonEvent)soEvent, soEventCallback.getAction());
                } else if (SoMouseButtonEvent.isButtonReleaseEvent((SoEvent)soEvent, (SoMouseButtonEvent.Buttons)SoMouseButtonEvent.Buttons.ANY)) {
                    SceneInteractor.this.mouseReleased((SoMouseButtonEvent)soEvent, soEventCallback.getAction());
                }
            }
        }
    }

    private class KeyboardEventCallbackCB
    extends SoEventCallbackCB {
        private KeyboardEventCallbackCB() {
        }

        public void invoke(SoEventCallback soEventCallback) {
            SoEvent soEvent = soEventCallback.getEvent();
            if (soEvent != null) {
                if (SoKeyboardEvent.isKeyPressEvent((SoEvent)soEvent, (SoKeyboardEvent.Keys)SoKeyboardEvent.Keys.ANY)) {
                    SceneInteractor.this.keyPressed((SoKeyboardEvent)soEvent, soEventCallback.getAction());
                } else if (SoKeyboardEvent.isKeyReleaseEvent((SoEvent)soEvent, (SoKeyboardEvent.Keys)SoKeyboardEvent.Keys.ANY)) {
                    SceneInteractor.this.keyReleased((SoKeyboardEvent)soEvent, soEventCallback.getAction());
                }
            }
        }
    }

    public static enum CameraMode {
        PERSPECTIVE,
        ORTHOGRAPHIC;

    }
}

