/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.nodes;

import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.viewercomponents.SoCameraInteractor;
import com.openinventor.inventor.viewercomponents.nodes.Animator;

class SeekAnimator
extends Animator {
    private float m_duration;
    private float m_relativeDistance;
    private SoCameraInteractor m_cameraInteractor;
    private SoNode m_sceneGraph;
    private SbViewportRegion m_vpRegion;
    private SbVec3f m_saveCameraPosition;
    private SbRotation m_saveCameraOrientation;
    private SbRotation m_newCameraOrientation;
    private SbVec3f m_newCameraPosition;
    private long m_startTime;
    private final boolean m_isAutoClippingPlanes;

    public SeekAnimator(SoCameraInteractor soCameraInteractor, SoNode soNode) {
        this.m_cameraInteractor = soCameraInteractor;
        this.m_sceneGraph = soNode;
        this.m_duration = 2.0f;
        this.m_relativeDistance = 50.0f;
        this.m_isAutoClippingPlanes = SoPreferences.getBoolean((String)"OIV_SCENE_EXAMINER_AUTO_CLIPPING_PLANES", (boolean)true);
    }

    public void setCameraInteractor(SoCameraInteractor soCameraInteractor) {
        this.m_cameraInteractor = soCameraInteractor;
    }

    public void setSceneGraph(SoNode soNode) {
        this.m_sceneGraph = soNode;
    }

    public float getDuration() {
        return this.m_duration;
    }

    public void setDuration(float f) {
        this.m_duration = f;
    }

    public float getRelativeDistance() {
        return this.m_relativeDistance;
    }

    public void setRelativeDistance(float f) {
        this.m_relativeDistance = f;
    }

    public void setUp(SbVec3f sbVec3f, SbViewportRegion sbViewportRegion) {
        this.m_vpRegion = sbViewportRegion;
        SbVec3f sbVec3f2 = new SbVec3f();
        SbMatrix sbMatrix = new SbMatrix();
        SoCamera soCamera = this.m_cameraInteractor.getCamera();
        this.m_saveCameraPosition = new SbVec3f(soCamera.position.getValue());
        this.m_saveCameraOrientation = new SbRotation(soCamera.orientation.getValue());
        SbVec3f sbVec3f3 = sbVec3f.minus(soCamera.position.getValue());
        float f = sbVec3f3.length() * (this.m_relativeDistance / 100.0f);
        soCamera.focalDistance.setValue(f);
        sbMatrix.setRotate(soCamera.orientation.getValue());
        float[] fArray = sbMatrix.getColumn(2);
        sbVec3f2.setValue(-fArray[0], -fArray[1], -fArray[2]);
        SbRotation sbRotation = new SbRotation();
        SbVec3f sbVec3f4 = sbVec3f.minus(soCamera.position.getValue());
        sbRotation.setValue(sbVec3f2, sbVec3f4);
        this.m_newCameraOrientation = soCamera.orientation.getValue().times(sbRotation);
        sbMatrix.setRotate(this.m_newCameraOrientation);
        fArray = sbMatrix.getColumn(2);
        sbVec3f2.setValue(-fArray[0], -fArray[1], -fArray[2]);
        sbVec3f4 = sbVec3f2.times(f);
        this.m_newCameraPosition = sbVec3f.minus(sbVec3f4);
    }

    @Override
    public void start() {
        if (this.m_duration == 0.0f) {
            this.interpolateSeekAnimation(1.0f);
        } else {
            super.start();
            this.m_startTime = System.currentTimeMillis();
        }
    }

    @Override
    protected void animate() {
        long l = System.currentTimeMillis();
        long l2 = l - this.m_startTime;
        float f = (float)l2 / (1000.0f * this.m_duration);
        if (f > 1.0f) {
            f = 1.0f;
        } else if ((double)(1.0f - f) < 1.0E-4) {
            f = 1.0f;
        }
        this.interpolateSeekAnimation(f);
        if (f == 1.0f) {
            this.stop();
        }
    }

    private void interpolateSeekAnimation(float f) {
        float f2 = (float)(0.5 - 0.5 * Math.cos((double)f * Math.PI));
        this.m_cameraInteractor.setOrientation(SbRotation.slerp((SbRotation)this.m_saveCameraOrientation, (SbRotation)this.m_newCameraOrientation, (float)f2));
        SbVec3f sbVec3f = this.m_newCameraPosition.minus(this.m_saveCameraPosition);
        sbVec3f.multiply(f2);
        sbVec3f.add(this.m_saveCameraPosition);
        this.m_cameraInteractor.setPosition(sbVec3f);
        if (this.m_isAutoClippingPlanes) {
            this.m_cameraInteractor.adjustClippingPlanes(this.m_sceneGraph, this.m_vpRegion);
        }
    }
}

