/* !!GLSL Vertex Shader */

uniform float AnimStep;

void main()
{  
  vec4 tmp = gl_Vertex;

  // Modification of the z and y coordinates of the vertex to create the movement
  tmp.z = sin(2.0 * tmp.x - AnimStep) * (tmp.x / 10.0);
  tmp.y = tmp.y + cos(2.0 * tmp.z) / 5.0;
  
  // Setting of the output position of the vertex 
  gl_Position = gl_ModelViewProjectionMatrix * tmp;
  
  // Texture coordinates 
  gl_TexCoord[0] = gl_MultiTexCoord0;
}