/* !!GLSL */

varying float diffuseLight;
varying float specularLight;
varying float edge;
varying vec4 diffuseColor;
varying vec4 specularColor;

// We don't need that uniform to be given by the API.
// By default, uniform are initialised to 0. It's what we want here.
uniform sampler2D ramp;

void main()
{
  // Create the texCoords  
  vec2 texCoordDiffuse  = vec2(diffuseLight, 0);
  vec2 texCoordSpecular = vec2(specularLight, 0);
  vec2 texCoordEdge     = vec2(edge, 0);

  // Apply the step function
  diffuseLight  = texture2D(ramp, texCoordDiffuse).x;
  specularLight = texture2D(ramp, texCoordSpecular).x;
  edge          = texture2D(ramp, texCoordEdge).x;

  // Compute the final color
  gl_FragColor   = edge * (diffuseColor*diffuseLight + specularColor*specularLight);
  gl_FragColor.w = 1.0;
} 
