/* !!GLSL */

uniform vec3 lightDirection;

varying float  diffuseLight;
varying float  specularLight;
varying float  edge;
varying float4 diffuseColor;
varying float4 specularColor;

varying vec3 diff;

void main()
{
  // Retreives diffuse and specular color from the OpenGL state
  diffuseColor   = gl_FrontMaterial.diffuse;
  specularColor  = gl_FrontMaterial.specular;

  // Set the output position of the vertex 
  gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;

  // Transform the position and normal in eye space
  vec4 tmpGlVertex = gl_ModelViewMatrix * gl_Vertex;
  vec3 tmpGlNormal = gl_NormalMatrix * gl_Normal;

  // Calculate the diffuse lighting
  vec3 N       = normalize(tmpGlNormal);
  diffuseLight = max(dot(N, lightDirection), 0);

  // Calculate the specular lighting
  vec3 V      = normalize(-tmpGlVertex.xyz);
  vec3 H      = normalize(lightDirection + V);
  specularLight = pow(max(dot(N, H), 0), gl_FrontMaterial.shininess);
  if(diffuseLight <= 0) 
    specularLight = 0;

  // Perform edge detection
  edge = max(dot(N, V), 0);
} 
