#version 120 
#extension GL_EXT_geometry_shader4 : enable

uniform float BarWidth;

/******************************************************************************/
// Compute the diffuse color according to the normal.
vec4
computeDiffuseColor( vec3 normal )
{
  vec3 tNormal = normalize( gl_NormalMatrix * normal );
  return ( max( dot( tNormal, vec3( gl_LightSource[0].position ) ), 0. ) * gl_FrontColorIn[0] );
}/******************************************************************************/

void main(void)
{
	int i;
	
	for ( i=0; i< gl_VerticesIn; i++ )
	{
	  vec4 posIn = gl_PositionIn[i];
	  vec4 position;
	  position.w = posIn.w;
	  
	  // 1st face
	  position.x = posIn.x - BarWidth;
	  position.y = posIn.y - BarWidth;
	  position.z = 0.0;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  gl_FrontColor = computeDiffuseColor( vec3( 0, -1, 0 ) );
	  EmitVertex();
	  
	  position.z = posIn.z;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
		
	  position.x = posIn.x + BarWidth;
	  position.z = 0.0;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	
	  position.z = posIn.z;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	  EndPrimitive();
	  
	  // 2nd face
	  position.z = 0.0;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  gl_FrontColor = computeDiffuseColor( vec3( 1, 0, 0 ) );
	  EmitVertex();
	  
	  position.z = posIn.z;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	  
	  position.y = posIn.y + BarWidth;
	  position.z = 0.0;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	
	  position.z = posIn.z;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	  EndPrimitive();
	
      // 3rd face
      position.z = 0.0;
      gl_Position = gl_ModelViewProjectionMatrix * position;
      gl_FrontColor = computeDiffuseColor( vec3( 0, 1, 0 ) );
      EmitVertex();
     
      position.z = posIn.z;
      gl_Position = gl_ModelViewProjectionMatrix * position;
      EmitVertex();

	  position.x = posIn.x - BarWidth;
	  position.z = 0.0;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	  
	  position.z = posIn.z;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	  EndPrimitive();

	  // 4th face
	  position.z = 0.0;
	  gl_FrontColor = computeDiffuseColor( vec3( -1, 0, 0 ) );
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	  
	  position.z = posIn.z;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	  	  
	  position.y = posIn.y - BarWidth;
	  position.z = 0.0;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	  
	  position.z = posIn.z;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	  EndPrimitive();
	  
	  // 5th face
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  gl_FrontColor = computeDiffuseColor( vec3( 0, 0, 1 ) );
	  EmitVertex();
	  
	  position.y = posIn.y + BarWidth;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	  
	  position.x = posIn.x + BarWidth;
	  position.y = posIn.y - BarWidth;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	  
	  position.y =  posIn.y + BarWidth;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	  EndPrimitive();
	  
	  // 6th face
	  position.x = posIn.x - BarWidth;
	  position.y = posIn.y - BarWidth;
	  position.z = 0.0;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  gl_FrontColor = computeDiffuseColor( vec3( 0, 0, -1 ) );
	  EmitVertex();
	  
	  position.y = posIn.y + BarWidth;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	  
	  position.x = posIn.x + BarWidth;
	  position.y = posIn.y - BarWidth;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	  
	  position.y =  posIn.y + BarWidth;
	  gl_Position = gl_ModelViewProjectionMatrix * position;
	  EmitVertex();
	  EndPrimitive();	  
	}
		
}/******************************************************************************/