package imageviz.algorithms.centerLine;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;

import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import com.openinventor.imageviz.engines.imagesegmentation.computationalgeometry.SoCenterLineApproximation3d;
import com.openinventor.imageviz.engines.imagesegmentation.labeling.SoLabelingProcessing;
import com.openinventor.imageviz.nodes.images.SoFileDataAdapter;
import com.openinventor.imageviz.nodes.images.SoImageDataAdapter.Interpretations;
import com.openinventor.imageviz.nodes.images.SoVRImageDataReader;
import com.openinventor.inventor.nodes.SoDrawStyle;
import com.openinventor.inventor.nodes.SoIndexedLineSet;
import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoPickStyle;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.nodes.SoDataRange;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;
import com.openinventor.volumeviz.nodes.SoVolumeRenderingQuality;
import com.openinventor.volumeviz.nodes.SoVolumeShape.Interpolations;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private static final String filename = "$OIVJHOME/data/imageviz/medicalFoot.binary.am";

  private IViewerExaminer myRenderArea;

  @Override
  public void start()
  {
    myRenderArea = ViewerComponentsFactory.createViewerExaminer();

    // the top level separator
    SoSeparator root = new SoSeparator();

    // Instantiate the appropriate image adapter using SoFileDataAdapter
    SoFileDataAdapter imageAdapter = new SoFileDataAdapter();
    imageAdapter.fileName.setValue(filename);
    imageAdapter.interpretation.setValue(Interpretations.BINARY);

    // material
    final SoMaterial volMat = new SoMaterial();

    // separator dedicated to the binary image
    SoSeparator inputVolumeSeparator = new SoSeparator();
    {
      // Create ImageViz reader for VolumeViz
      // engineDuration.reset();
      SoVRImageDataReader inputImageReader = new SoVRImageDataReader();
      inputImageReader.imageData.setValue(imageAdapter);

      // VolumeData for display
      SoVolumeData volumeFilteredImage = new SoVolumeData();
      volumeFilteredImage.setReader(inputImageReader);
      inputVolumeSeparator.addChild(volumeFilteredImage);

      // volume rendering settings
      SoVolumeRenderingQuality volQual = new SoVolumeRenderingQuality();
      volQual.deferredLighting.setValue(true);
      volQual.ambientOcclusion.setValue(true);
      volQual.voxelizedRendering.setValue(true);
      volQual.voxelOutline.setValue(true);

      // Node in charge of drawing the volume
      SoVolumeRender volRender = new SoVolumeRender();
      volRender.interpolation.setValue(Interpolations.NEAREST);

      // colormap
      SoTransferFunction colorMap = new SoTransferFunction();
      colorMap.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.LABEL_256);
      colorMap.minValue.setValue(0);
      colorMap.maxValue.setValue(2);

      // add a Data Range to be sure to map data properly
      SoDataRange dataRange = new SoDataRange();
      dataRange.min.setValue(0);
      dataRange.max.setValue(255);

      // build the scene graph for the volume rendering
      inputVolumeSeparator.addChild(volumeFilteredImage);
      inputVolumeSeparator.addChild(colorMap);
      inputVolumeSeparator.addChild(dataRange);
      inputVolumeSeparator.addChild(volQual);
      inputVolumeSeparator.addChild(volMat);
      inputVolumeSeparator.addChild(volRender);
    }

    // separator for the line set result
    SoSeparator lineSetSeparator = new SoSeparator();
    {
      // Lines are unpickable, unlit, and wide
      SoPickStyle pickStyle = new SoPickStyle();
      pickStyle.style.setValue(SoPickStyle.Styles.UNPICKABLE);

      // drawstyle for line
      SoDrawStyle drawStyle = new SoDrawStyle();
      drawStyle.lineWidth.setValue(2);

      // light model
      SoLightModel lightModel = new SoLightModel();
      lightModel.model.setValue(SoLightModel.Models.BASE_COLOR);

      // extract the centerline
      SoLabelingProcessing labeling = new SoLabelingProcessing();
      labeling.inObjectImage.setValue(imageAdapter);

      // engineDuration.reset();
      SoCenterLineApproximation3d centerlineExtractor = new SoCenterLineApproximation3d();
      centerlineExtractor.inLabelImage.connectFrom(labeling.outLabelImage);
      centerlineExtractor.autoMode.setValue(true);
      centerlineExtractor.newBranchSensibility.setValue(4.0);
      centerlineExtractor.distanceMapSmoothing.setValue(0.01);
      centerlineExtractor.smoothingIteration.setValue(2);

      SoIndexedLineSet clLineSet = centerlineExtractor.outLineSet.getValue();

      // build the lineset sub graph
      lineSetSeparator.addChild(pickStyle);
      lineSetSeparator.addChild(drawStyle);
      lineSetSeparator.addChild(lightModel);
      lineSetSeparator.addChild(clLineSet);
    }

    root.addChild(lineSetSeparator);
    root.addChild(inputVolumeSeparator);

    // create a transparency dialog
    Panel miscPanel = new Panel(new GridLayout(2, 2));

    int defaultValue = 50;
    volMat.transparency.setValue(0.9f + defaultValue / 1000.0f);
    final JLabel sliderLabel = new JLabel("Transparency: " + Float.toString(0.9f + defaultValue / 1000.0f));
    JSlider slider = new JSlider(JSlider.HORIZONTAL, 0, 100, defaultValue);

    slider.addChangeListener(new ChangeListener()
    {
      @Override
      public void stateChanged(ChangeEvent event)
      {
        float transparency = 0.9f + ((JSlider) event.getSource()).getValue() / 1000.0f;
        sliderLabel.setText("Transparency: " + Float.toString(transparency));
        volMat.transparency.setValue(transparency);
      }
    });

    miscPanel.add(sliderLabel);
    miscPanel.add(slider);

    myRenderArea.setSceneGraph(root);
    myRenderArea.viewAll();

    final Component component = myRenderArea.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(miscPanel, BorderLayout.SOUTH);
  }

  @Override
  public void stop()
  {
    myRenderArea.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("ImageViz - Centerline");
  }

}
