package imageviz.algorithms.iterativeMorphoLut2D;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.openinventor.imageviz.SbKernel2i32;
import com.openinventor.imageviz.nodes.images.SoFileDataAdapter;
import com.openinventor.imageviz.nodes.images.SoImageDataAdapter.Interpretations;
import com.openinventor.imageviz.nodes.images.SoVRImageDataReader;
import com.openinventor.inventor.nodes.SoMultiSwitch;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoOrthoSlice;
import com.openinventor.volumeviz.nodes.SoVolumeData;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private static final String filename = "$OIVJHOME/data/imageviz/objects-skeleton.tif";

  private IViewerExaminer myRenderArea;
  private SoMultiSwitch root;

  @Override
  public void start()
  {
    myRenderArea = ViewerComponentsFactory.createViewerExaminer();

    // 1- Instantiate the appropriate image adapter using SoFileDataAdapter
    SoFileDataAdapter imageAdapter = new SoFileDataAdapter();
    imageAdapter.fileName.setValue(filename);
    imageAdapter.interpretation.setValue(Interpretations.BINARY);

    // 2- Apply custom operation
    // 2.1- instanciate the engine and connect it to input image data to perform
    // a morphological thinning operation
    SoIterativeMorphoLutProcessing2D iterativeProcess = new SoIterativeMorphoLutProcessing2D();
    iterativeProcess.inBinaryImage.setValue(imageAdapter);
    iterativeProcess.inIterations.setValue(5);
    iterativeProcess.inOperationMode.setValue(SoIterativeMorphoLutProcessing2D.OperationMode.THINNING);
    iterativeProcess.inRotationMode.setValue(SoIterativeMorphoLutProcessing2D.RotationMode.ROTATE_VERTICES);
    {
      // Define a kernel like
      // 0 0 0
      // 0 1 1
      // 0 0 0
      SbKernel2i32 kernel = new SbKernel2i32(3, 3); // Default init values are 0
      kernel.setValue(1, 1, 1);
      kernel.setValue(2, 2, 1);
      iterativeProcess.inKernel2D.setValue(kernel);
    }

    // 2.2- instanciate the engine and connect it to input image data to perform
    // a morphological thinning operation
    SoIterativeMorphoLutProcessing2D iterativeProcess2 = new SoIterativeMorphoLutProcessing2D();
    iterativeProcess2.inBinaryImage.setValue(imageAdapter);
    iterativeProcess2.inIterations.setValue(5);
    iterativeProcess2.inOperationMode.setValue(SoIterativeMorphoLutProcessing2D.OperationMode.THICKENING);
    iterativeProcess2.inRotationMode.setValue(SoIterativeMorphoLutProcessing2D.RotationMode.ROTATE_VERTICES);
    {
      // Define a kernel like
      // X 1 X
      // 0 0 1
      // 0 X X
      SbKernel2i32 kernel = new SbKernel2i32(3, 3); // Default init values are 0
      kernel.setValue(0, 0, 2);
      kernel.setValue(1, 0, 1);
      kernel.setValue(1, 2, 2);
      kernel.setValue(2, 0, 2);
      kernel.setValue(2, 1, 1);
      kernel.setValue(2, 2, 2);
      iterativeProcess2.inKernel2D.setValue(kernel);
    }

    // 3- Three pairs of Readers/VolumeData are needed here.
    // 3.1- One to render the original image.
    SoVRImageDataReader inputImageReader = new SoVRImageDataReader();
    inputImageReader.imageData.setValue(imageAdapter);
    SoVolumeData volumeInputImage = new SoVolumeData();
    volumeInputImage.setReader(inputImageReader);

    // 3.2- One to render the first computed image.
    // 3.2- Directly connect this reader to the output of the filter
    SoVRImageDataReader filteredImageReader = new SoVRImageDataReader();
    filteredImageReader.imageData.connectFrom(iterativeProcess.outBinaryImage);
    SoVolumeData volumeThinningImage = new SoVolumeData();
    volumeThinningImage.setReader(filteredImageReader);

    // 3.2- One to render the first computed image.
    // 3.2- Directly connect this reader to the output of the filter
    SoVRImageDataReader filteredImageReader2 = new SoVRImageDataReader();
    filteredImageReader2.imageData.connectFrom(iterativeProcess2.outBinaryImage);
    SoVolumeData volumeThickeningImage = new SoVolumeData();
    volumeThickeningImage.setReader(filteredImageReader2);

    // 4- Element for the scene graph
    // 4- Now the main connection have been made, we need to build a scene graph
    // 4- to render the data.
    root = new SoMultiSwitch();
    root.traversalMode.setValue(SoMultiSwitch.TraversalModes.INCLUDE);
    root.whichChildren.set("[ 0, 1, 2 ]");

    // 4.1- Thickening image
    // 4.1.2- Use a simple orthoslice for thickening image
    SoOrthoSlice orthoSliceThickening = new SoOrthoSlice();

    // 4.1.3- With a colormap to display pixels of intensity 1 in blue
    SoTransferFunction colorMapThickening = new SoTransferFunction();
    colorMapThickening.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.STANDARD);
    colorMapThickening.minValue.setValue(1);
    colorMapThickening.maxValue.setValue(1);

    // 4.1.4- Add to the scene graph
    SoSeparator sepThickening = new SoSeparator();
    sepThickening.addChild(volumeThickeningImage);
    sepThickening.addChild(colorMapThickening);
    sepThickening.addChild(orthoSliceThickening);
    root.addChild(sepThickening);

    // 4.2- Original image
    // 4.2.1- Use a simple orthoslice for original image
    SoOrthoSlice orthoSliceOriginal = new SoOrthoSlice();
    // 4.2.1- With a colormap to display pixels of intensity 1 in white
    SoTransferFunction colorMapOriginal = new SoTransferFunction();
    colorMapOriginal.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.GRAY);
    colorMapOriginal.minValue.setValue(128);
    colorMapOriginal.maxValue.setValue(255);

    // 4.2.4- Add to the scene graph
    SoSeparator sepOriginal = new SoSeparator();
    sepOriginal.addChild(volumeInputImage);
    sepOriginal.addChild(colorMapOriginal);
    sepOriginal.addChild(orthoSliceOriginal);
    root.addChild(sepOriginal);

    // 4.3- Thinning image
    // 4.2- Use a simple orthoslice for thinning image
    SoOrthoSlice orthoSliceThinning = new SoOrthoSlice();

    // 4.3- With a colormap to display pixels of intensity 1 in blue
    SoTransferFunction colorMapThinning = new SoTransferFunction();
    colorMapThinning.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.BLUE_RED);
    colorMapThinning.minValue.setValue(1);
    colorMapThinning.maxValue.setValue(1);

    // 4.4- Add to the scene graph
    SoSeparator sepThinning = new SoSeparator();
    sepThinning.addChild(volumeThinningImage);
    sepThinning.addChild(colorMapThinning);
    sepThinning.addChild(orthoSliceThinning);
    root.addChild(sepThinning);

    myRenderArea.setSceneGraph(root);
    myRenderArea.viewAll();

    JPanel operationPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
    JLabel operationLabel = new JLabel("Operation type");
    String[] operationTypes = { "ALL", "THICKENING", "THINNING", "NONE" };
    JComboBox<String> operationBox = new JComboBox<>(operationTypes);
    operationBox.addActionListener(new OperationBoxListener());
    operationBox.setSelectedItem("NONE");
    operationPanel.add(operationLabel);
    operationPanel.add(operationBox);

    final Component component = myRenderArea.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(operationPanel, BorderLayout.SOUTH);
  }

  @Override
  public void stop()
  {
    myRenderArea.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("ImageViz - IterativeMorphoLut2D");
  }

  private class OperationBoxListener implements ActionListener
  {
    @Override
    public void actionPerformed(ActionEvent e)
    {
      JComboBox<?> operationBox = (JComboBox<?>) e.getSource();
      switch ( operationBox.getSelectedIndex() )
      {
      case 0 : // All
        root.whichChildren.set("[ 0, 1, 2 ]");
        break;

      case 1 : // Thickening
        root.whichChildren.set("[ 0, 1 ]");
        break;

      case 2 : // Thinning
        root.whichChildren.set("[ 1, 2 ]");
        break;

      default: // None
        root.whichChildren.set("[ 1 ]");
        break;
      }
    }
  }
}
