package imageviz.algorithms.iterativeMorphoLut3D;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.imageviz.SbKernel3i32;
import com.openinventor.imageviz.engines.arithmeticandlogic.logicaloperations.SoInvertImageProcessing;
import com.openinventor.imageviz.engines.imagesegmentation.binarization.SoThresholdingProcessing;
import com.openinventor.imageviz.engines.imagesegmentation.separatingandfilling.SoSeparateObjectsProcessing;
import com.openinventor.imageviz.engines.mathematicalmorphology.hitormissandskeleton.SoSkeletonProcessing2d;
import com.openinventor.imageviz.engines.mathematicalmorphology.openingandclosing.SoClosingBallProcessing3d;
import com.openinventor.imageviz.nodes.images.SoFileDataAdapter;
import com.openinventor.imageviz.nodes.images.SoVRImageDataReader;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.nodes.SoDataRange;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;
import com.openinventor.volumeviz.nodes.SoVolumeRenderingQuality;
import com.openinventor.volumeviz.nodes.SoVolumeShape;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private static final String filename = "$OIVJHOME/data/imageviz/foam.ldm";
  private static final String colorMapToLoad = "$OIVJHOME/data/imageviz/colormaps/colorMapFoam.am";

  private IViewerExaminer myRenderArea;

  @Override
  public void start()
  {
    myRenderArea = ViewerComponentsFactory.createViewerExaminer();

    // 1- Instantiate the appropriate image adapter using SoFileDataAdapter
    SoFileDataAdapter imageAdapter = new SoFileDataAdapter();
    imageAdapter.fileName.setValue(filename);

    // 2- Prepare the image
    // 2.1- Binarization of the image
    SoThresholdingProcessing threshholdFilter = new SoThresholdingProcessing();
    threshholdFilter.computeMode.setValue(SoThresholdingProcessing.ComputeModes.MODE_3D);
    threshholdFilter.inImage.setValue(imageAdapter);

    // 2.2- Fill small holes
    SoClosingBallProcessing3d closingFilter = new SoClosingBallProcessing3d();
    closingFilter.inImage.connectFrom(threshholdFilter.outBinaryImage);

    // 2.3- Invert the image to identify vaccum
    SoInvertImageProcessing invertFilter = new SoInvertImageProcessing();
    invertFilter.inImage.connectFrom(closingFilter.outImage);

    // 2.4- Separate bubbles
    SoSeparateObjectsProcessing separateFilter = new SoSeparateObjectsProcessing();
    separateFilter.computeMode.setValue(SoSeparateObjectsProcessing.ComputeModes.MODE_3D);
    separateFilter.inBinaryImage.connectFrom(invertFilter.outImage);

    // 2.5- Skeletonize
    SoSkeletonProcessing2d skeletonFilter = new SoSkeletonProcessing2d();
    skeletonFilter.computeMode.setValue(SoSkeletonProcessing2d.ComputeModes.MODE_3D);
    skeletonFilter.inBinaryImage.connectFrom(separateFilter.outSeparationImage);

    // 2- Apply custom operation
    // 2.1- instanciate the engine and connect it to input image data to perform
    // a morphological thinning operation
    SoIterativeMorphoLutProcessing3D iterativeProcess = new SoIterativeMorphoLutProcessing3D();
    iterativeProcess.inBinaryImage.connectFrom(skeletonFilter.outBinaryImage);
    iterativeProcess.inIterations.setValue(5);
    iterativeProcess.inOperationMode.setValue(SoIterativeMorphoLutProcessing3D.OperationMode.THINNING);
    iterativeProcess.inRotationMode.setValue(SoIterativeMorphoLutProcessing3D.RotationMode.ROTATE_VERTICES);
    {
      // Define a kernel like
      // 0 0 0 0 0 0 0 0 0
      // 0 0 0 0 1 1 0 0 0
      // 0 0 0 0 0 0 0 0 0
      SbKernel3i32 kernel = new SbKernel3i32(3, 3, 3); // Default init values
                                                       // are 0
      kernel.setValue(1, 1, 1, 1);
      kernel.setValue(2, 1, 1, 1);
      iterativeProcess.inKernel3D.setValue(kernel);
    }

    // 3- Three pairs of Readers/VolumeData are needed here.
    // 3.1- One to render the original image.
    SoVRImageDataReader inputImageReader = new SoVRImageDataReader();
    inputImageReader.imageData.setValue(imageAdapter);
    SoVolumeData volumeInputImage = new SoVolumeData();
    volumeInputImage.setReader(inputImageReader);

    // 3.2- One to render the skeleton image.
    // 3.2- Directly connect this reader to the output of the filter
    SoVRImageDataReader skeletonImageReader = new SoVRImageDataReader();
    skeletonImageReader.imageData.connectFrom(skeletonFilter.outBinaryImage);
    SoVolumeData volumeSkeletonImage = new SoVolumeData();
    volumeSkeletonImage.setReader(skeletonImageReader);

    // 3.2- One to render the computed image.
    // 3.2- Directly connect this reader to the output of the filter
    SoVRImageDataReader filteredImageReader = new SoVRImageDataReader();
    filteredImageReader.imageData.connectFrom(iterativeProcess.outBinaryImage);
    SoVolumeData volumeThinningImage = new SoVolumeData();
    volumeThinningImage.setReader(filteredImageReader);

    // 4- Element for the scene graph
    // 4- Now the main connection have been made, we need to build a scene graph
    // 4- to render the data. We mainly want to show the data before and after

    // 4-1 input image.
    SoSeparator root = new SoSeparator();
    root.addChild(new SoGradientBackground());
    {
      SoSeparator sep = new SoSeparator();

      SoVolumeRender volRend = new SoVolumeRender();
      volRend.samplingAlignment.setValue(SoVolumeRender.SamplingAlignments.SMOOTH_BOUNDARY_ALIGNED);

      // Define the interest range (interactive thereshold)
      SoDataRange dataRange = new SoDataRange();
      dataRange.min.setValue(24);
      dataRange.max.setValue(26);

      SoTransferFunction colorMap = new SoTransferFunction();
      colorMap.loadColormap(colorMapToLoad);

      SoVolumeRenderingQuality volQual = new SoVolumeRenderingQuality();
      volQual.ambientOcclusion.setValue(true);
      volQual.deferredLighting.setValue(true);

      sep.addChild(volumeInputImage);
      sep.addChild(dataRange);
      sep.addChild(colorMap);
      sep.addChild(volQual);
      sep.addChild(volRend);
      root.addChild(sep);
    }

    // 4-2 skeleton image.
    {
      SoSeparator sep = new SoSeparator();

      SoMaterial mat = new SoMaterial();
      mat.transparency.setValue(0.001f);

      SoVolumeRender volRend = new SoVolumeRender();
      volRend.interpolation.setValue(SoVolumeShape.Interpolations.NEAREST);
      volRend.numSlicesControl.setValue(SoVolumeRender.NumSlicesControls.MANUAL);
      volRend.numSlices.setValue(5000);

      SoDataRange dataRange = new SoDataRange();
      dataRange.min.setValue(0);
      dataRange.max.setValue(1);

      SoTransferFunction colorMap = new SoTransferFunction();
      colorMap.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.TEMPERATURE);
      colorMap.minValue.setValue(1);
      colorMap.maxValue.setValue(255);

      SoVolumeRenderingQuality volQual = new SoVolumeRenderingQuality();
      volQual.ambientOcclusion.setValue(true);
      volQual.deferredLighting.setValue(true);

      sep.addChild(volumeSkeletonImage);
      sep.addChild(dataRange);
      sep.addChild(colorMap);
      sep.addChild(volQual);
      sep.addChild(volRend);
      root.addChild(sep);
    }

    // 4-3 thinning image.
    {
      SoSeparator sep = new SoSeparator();

      SoVolumeRender volRend = new SoVolumeRender();

      SoDataRange dataRange = new SoDataRange();
      dataRange.min.setValue(0);
      dataRange.max.setValue(1);

      SoTransferFunction colorMap = new SoTransferFunction();
      colorMap.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.BLUE_RED);
      colorMap.minValue.setValue(1);
      colorMap.maxValue.setValue(255);

      SoVolumeRenderingQuality volQual = new SoVolumeRenderingQuality();
      volQual.voxelizedRendering.setValue(true);
      volQual.ambientOcclusion.setValue(true);
      volQual.deferredLighting.setValue(true);

      sep.addChild(volumeThinningImage);
      sep.addChild(dataRange);
      sep.addChild(colorMap);
      sep.addChild(volQual);
      sep.addChild(volRend);
      root.addChild(sep);
    }

    myRenderArea.setSceneGraph(root);
    myRenderArea.viewAll();

    final Component component = myRenderArea.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myRenderArea.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("ImageViz - IterativeMorphoLut3D");
  }
}
