package imageviz.algorithms.iterativeMorphoLut3D;

import com.openinventor.imageviz.SbKernel3i32;
import com.openinventor.imageviz.engines.SoImageVizEngineOutput;
import com.openinventor.imageviz.engines.mathematicalmorphology.hitormissandskeleton.SoApplyMorphologicalLutProcessing3d;
import com.openinventor.imageviz.fields.SoSFImageDataAdapter;
import com.openinventor.imageviz.fields.SoSFKernel3i32;
import com.openinventor.imageviz.nodes.images.SoImageDataAdapter;
import com.openinventor.imageviz.nodes.luts.SoMorphoLut3D;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.engines.SoEngine;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoField.FieldTypes;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFInt32;

public class SoIterativeMorphoLutProcessing3D extends SoEngine
{
  private boolean m_inputsAreChanged;

  public final SoSFImageDataAdapter inBinaryImage;

  public enum OperationMode implements com.openinventor.inventor.IntegerValuedEnum
  {
    THINNING(0), THICKENING(1), HIT_OR_MISS(2);

    private int value;

    private OperationMode(int value)
    {
      this.value = value;
    }

    @Override
    public int getValue()
    {
      return value;
    }
  }

  public final SoSFEnum<OperationMode> inOperationMode;

  public enum RotationMode implements com.openinventor.inventor.IntegerValuedEnum
  {
    NO_ROTATION(0), ROTATE_FACES(1), ROTATE_EDGES(2), ROTATE_VERTICES(3);

    private int value;

    private RotationMode(int value)
    {
      this.value = value;
    }

    @Override
    public int getValue()
    {
      return value;
    }
  }

  public final SoSFEnum<RotationMode> inRotationMode;

  public final SoSFKernel3i32 inKernel3D;

  public final SoSFInt32 inIterations;

  public final SoImageVizEngineOutput<SoSFImageDataAdapter, SoImageDataAdapter> outBinaryImage;

  @SuppressWarnings("unchecked")
  public SoIterativeMorphoLutProcessing3D()
  {
    inBinaryImage = new SoSFImageDataAdapter(this, "inBinaryImage", FieldTypes.EXPOSED_FIELD, null);
    inOperationMode =
        new SoSFEnum<OperationMode>(this, "inOperationMode", FieldTypes.EXPOSED_FIELD, OperationMode.class,
            OperationMode.THINNING);
    inRotationMode =
        new SoSFEnum<RotationMode>(this, "inRotationMode", FieldTypes.EXPOSED_FIELD, RotationMode.class,
            RotationMode.NO_ROTATION);
    inKernel3D = new SoSFKernel3i32(this, "inKernel", FieldTypes.EXPOSED_FIELD, new SbKernel3i32());
    inIterations = new SoSFInt32(this, "inIterations", FieldTypes.EXPOSED_FIELD, 1);
    outBinaryImage =
        (SoImageVizEngineOutput<SoSFImageDataAdapter, SoImageDataAdapter>) SoImageVizEngineOutput.newInstance(
            SoImageDataAdapter.class, this, "outBinaryImage");
  }

  @Override
  protected void inputChanged(SoField whichField)
  {
    m_inputsAreChanged = true;
  }

  @Override
  protected void evaluate()
  {
    // Do nothing if inputs are not modified
    if ( !m_inputsAreChanged )
      return;

    // Check if inputs are valid
    // for inBinaryImage
    if ( inBinaryImage.getValue() == null )
      return; // No image

    // for inKernel
    if ( !inKernel3D.getValue().getSize().equals(new SbVec3i32(3, 3, 3)) )
      return; // Invalid kernel

    // Init the base operator for iteration
    SoApplyMorphologicalLutProcessing3d applyLut = new SoApplyMorphologicalLutProcessing3d();

    // Chose the appropriate matching flags corresponding to the user input.
    switch ( inOperationMode.getValue(OperationMode.class) )
    {
    case THICKENING :
    {
      applyLut.matchingFlag.setValue(SoApplyMorphologicalLutProcessing3d.MatchingActions.SET_ONE);
      applyLut.noMatchingFlag.setValue(SoApplyMorphologicalLutProcessing3d.MatchingActions.SET_UNCHANGE);
      break;
    }
    case HIT_OR_MISS :
    {
      applyLut.matchingFlag.setValue(SoApplyMorphologicalLutProcessing3d.MatchingActions.SET_ONE);
      applyLut.noMatchingFlag.setValue(SoApplyMorphologicalLutProcessing3d.MatchingActions.SET_ZERO);
      break;
    }
    default:
    {
      applyLut.matchingFlag.setValue(SoApplyMorphologicalLutProcessing3d.MatchingActions.SET_ZERO);
      applyLut.noMatchingFlag.setValue(SoApplyMorphologicalLutProcessing3d.MatchingActions.SET_UNCHANGE);
      break;
    }

    }

    // Build the Morpho lut
    applyLut.morphologicalLut.setValue(buildInternalMorphoLut());

    // Init the loop
    SoImageDataAdapter outputApplyLut = inBinaryImage.getValue();
    int numIterations = inIterations.getValue();
    int computedIterations = 0;
    long numPixelsModified;

    // While the limit of modified pixels is not reached, apply the lut
    do
    {
      // BE AWARE TO DO NOT RE-INJECT DIRECTLY THE OUTPUT ON THE INPUT
      // Because when changing the input, output is re-computed, you have to
      // store it before
      SoImageDataAdapter inputApplyLut = outputApplyLut;
      applyLut.inBinaryImage.setValue(inputApplyLut);
      outputApplyLut = applyLut.outBinaryImage.getValue();
      numPixelsModified = applyLut.outModifiedVoxels.getDetail(0).getVoxelNumber();
      computedIterations++;
    }
    while ( (numPixelsModified > 0) && ((numIterations == 0) || (computedIterations < numIterations)) );

    // After all, map the result to the output of the engine
    outBinaryImage.setValue(outputApplyLut);

    // Don't forget to stabilize the result to avoid excessive compute.
    m_inputsAreChanged = false;
  }

  private SoMorphoLut3D buildInternalMorphoLut()
  {
    // Define the Morpho LUT
    SoMorphoLut3D morphoLut = new SoMorphoLut3D();
    SbKernel3i32 usedKernel = inKernel3D.getValue();

    // This is the default insertion (can be done for each case)
    morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_NEW, 0, 0, 0);

    switch ( inRotationMode.getValue(RotationMode.class) )
    {
    case ROTATE_VERTICES :
    {
      // a lot of possibilities...
      for ( int ix = 0; ix < 8; ix++ )
        for ( int iy = 0; iy < 8; iy++ )
          for ( int iz = 0; iz < 8; iz++ )
            morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, ix, iy, iz);
      break;
    }

    case ROTATE_EDGES :
    {
      // Configuration on each edge + each face
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 1, 0, 0);
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 3, 0, 0);
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 5, 0, 0);
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 7, 0, 0);
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 0, 1, 0);
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 0, 3, 0);
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 0, 5, 0);
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 0, 7, 0);
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 0, 2, 1);
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 0, 2, 3);
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 0, 2, 5);
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 0, 2, 7);
      break;
    }

    case ROTATE_FACES :
    {
      // Configuration on each face
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 2, 0, 0);
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 4, 0, 0);
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 6, 0, 0);
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 0, 2, 0);
      morphoLut.insertKernel(usedKernel, SoMorphoLut3D.InsertModes.INSERT_OR, 0, 6, 0);
      break;
    }

    default:
    {
      // Nothing to do because it has been done previously
      break;
    }
    }

    return morphoLut;
  }
}
