package imageviz.gettingstarted.batchProcessing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;

import com.openinventor.imageviz.SbImageDataAdapterHelper;
import com.openinventor.imageviz.engines.edgedetection.gradient.SoGradientOperatorProcessing2d;
import com.openinventor.imageviz.engines.imagemanipulation.imageediting.SoConvertImageProcessing;
import com.openinventor.imageviz.nodes.images.SoFileDataAdapter;
import com.openinventor.imageviz.nodes.images.SoImageDataAdapter;
import com.openinventor.inventor.helpers.SbFileHelper;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoText3;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private static final String inputDirectory = "$OIVJHOME/data/imageviz/";
  private static final String outputDirectory = "$OIVJHOME/examples/imageviz/gettingstarted/batchprocessing";

  private IViewerExaminer myRenderArea;

  @Override
  public void start()
  {
    myRenderArea = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = new SoSeparator();

    // List of supported files in InputDirectory.
    // 1- Apply a morphological filter to a list of files.
    File dir = new File(SbFileHelper.expandString(inputDirectory));
    File[] inputFiles = new File[4];
    inputFiles[0] = new File(dir, "autorad.tif");
    inputFiles[1] = new File(dir, "objects-skeleton.tif");
    inputFiles[2] = new File(dir, "polystyrene.separated.tif");
    inputFiles[3] = new File(dir, "polystyrene.tif");

    // 1.1- Instantiate processing engines
    // 1.1.1- Define gradient operator
    SoGradientOperatorProcessing2d gradientProcess = new SoGradientOperatorProcessing2d();
    // Use the Sobel 3x3 kernel
    gradientProcess.gradientOperator.setValue(SoGradientOperatorProcessing2d.GradientOperators.SOBEL);
    // Compute the gradient amplitude
    gradientProcess.gradientMode.setValue(SoGradientOperatorProcessing2d.GradientModes.AMPLITUDE_EUCLIDEAN);

    // 1.1.2- Define a converting engine to convert the output type from 16 bits
    // to 8 bits
    SoConvertImageProcessing convertType = new SoConvertImageProcessing();
    convertType.dataType.setValue(SoConvertImageProcessing.DataTypes.UNSIGNED_CHAR);
    convertType.inImage.connectFrom(gradientProcess.outAmplitudeImage);

    // 1.2- For each file in input directory apply the filters
    SoText3 message = new SoText3();
    message.string.setNum(inputFiles.length);

    int fileIndex = 0;
    for ( File inputFilePath : inputFiles )
    {
      // Load input dataset and connect it to the gradient engine
      SoFileDataAdapter imageToLoad = new SoFileDataAdapter();
      imageToLoad.fileName.setValue(inputFilePath.getPath());
      gradientProcess.inImage.setValue(imageToLoad);

      // Apply the processing chain.
      SoImageDataAdapter dataAdapter = convertType.outImage.getValue();

      // 1.3- Write output file
      String inputFileName = inputFilePath.getName();
      System.out.println(inputFileName + "\t");

      // Save output file as tiff file with the same name in the output
      // directory.
      if ( null != dataAdapter )
      {
        SbImageDataAdapterHelper.saveToFile(dataAdapter,
            new File(outputDirectory, "Gradient_" + inputFileName).getPath());
        message.string.set1Value(fileIndex++, inputFileName + ": Sobel gradient performed");
      }
      else
        message.string.set1Value(fileIndex++, inputFileName + ": Sobel gradient failed");
    }

    root.addChild(message);

    myRenderArea.setSceneGraph(root);
    myRenderArea.viewAll();

    final Component component = myRenderArea.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myRenderArea.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("ImageViz - Batch processing");
  }
}
