package imageviz.gettingstarted.customAttribute;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.imageviz.SbImageDataAdapterHelper;
import com.openinventor.imageviz.engines.imageanalysis.individualmeasures.SoLabelAnalysisQuantification;
import com.openinventor.imageviz.engines.imagesegmentation.labeling.SoLabelingProcessing;
import com.openinventor.imageviz.nodes.analysis.SoLabelAnalysisResult;
import com.openinventor.imageviz.nodes.images.SoImageDataAdapter;
import com.openinventor.imageviz.nodes.images.SoImageDataAdapter.Interpretations;
import com.openinventor.imageviz.nodes.images.SoVRImageDataReader;
import com.openinventor.imageviz.nodes.measures.SoDataMeasureAttributes;
import com.openinventor.imageviz.nodes.measures.SoDataMeasurePredefined;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.nodes.SoDataRange;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoOrthoSlice;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeShape;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private static final String filename = "$OIVJHOME/data/imageviz/polystyrene.separated.tif";
  private static final String labelColormap = "$OIVJHOME/data/imageviz/colormaps/labels256.am";

  private IViewerExaminer myRenderArea;

  @Override
  public void start()
  {
    myRenderArea = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = new SoSeparator();

    // 1- Instantiate the appropriate image adapter using SoFileDataAdapter
    SoImageDataAdapter imageAdapter = SbImageDataAdapterHelper.getAppropriateAdapter(filename);
    imageAdapter.interpretation.setValue(Interpretations.BINARY);

    // 2- Apply a label processing engine on our image
    SoLabelingProcessing labelFilter = new SoLabelingProcessing();
    labelFilter.inObjectImage.setValue(imageAdapter);

    // 3- Use a Volume reader to read the labelled image
    SoVRImageDataReader filteredImageReader = new SoVRImageDataReader();
    filteredImageReader.imageData.connectFrom(labelFilter.outLabelImage);

    // 4- Give this reader as data input to the volume data
    SoVolumeData volumeLabelImage = new SoVolumeData();
    volumeLabelImage.setReader(filteredImageReader);

    // 5- Define the colormap we want to use. In our case
    // 5- We load it from the labelColormap file
    SoTransferFunction transFunc = new SoTransferFunction();
    transFunc.loadColormap(labelColormap);

    // 6- Node in charge of drawing the volume
    SoOrthoSlice orthoSlice = new SoOrthoSlice();
    orthoSlice.interpolation.setValue(SoVolumeShape.Interpolations.NEAREST);

    // 7- Add a Data Range to be sure to map data properly
    SoDataRange dataRange = new SoDataRange();
    dataRange.min.setValue(0);
    dataRange.max.setValue(255);

    // 8- Build a simple scenegraph
    // 8- Note: SoOrthoSlice must appear after the SoVolumeData node.
    root.addChild(volumeLabelImage);
    root.addChild(dataRange);
    root.addChild(transFunc);
    root.addChild(orthoSlice);

    // 10- Separately use 2 SoLabelAnalysisQuantification engines to compare
    // results with default attributes
    // 10- and custom attributes
    SoLabelAnalysisQuantification labelAnalysis1 = new SoLabelAnalysisQuantification();
    SoLabelAnalysisQuantification labelAnalysis2 = new SoLabelAnalysisQuantification();

    // 9.1- Specify the kind of measure we want to perform.
    // Create a predefined measure with custom attributes (set the Feret
    // attributes)

    // Define Feret 2D attribute with more precision than the default
    // distribution
    // Feret diameters will be computed each 2 degrees instead of each 18
    // degrees
    SoDataMeasureAttributes measureAttributes = new SoDataMeasureAttributes();
    measureAttributes.feretAngles2D.setNum(90);
    for ( int i = 0; i < 90; ++i )
    {
      measureAttributes.feretAngles2D.set1Value(i, i * 2.0f);
    }

    // Set the new attributes of the measure to the 2nd analysis
    labelAnalysis2.measureAttributes.setValue(measureAttributes);

    // Add the predefined measure that computes the Feret diameters ratio
    // (elongation factor)
    labelAnalysis1.measureList.set1Value(0,
        new SoDataMeasurePredefined(SoDataMeasurePredefined.PredefinedMeasures.FERET_DIAMETER_RATIO_2D));
    labelAnalysis2.measureList.set1Value(0,
        new SoDataMeasurePredefined(SoDataMeasurePredefined.PredefinedMeasures.FERET_DIAMETER_RATIO_2D));

    // 9.2- Plug input on the Label engine output and intensity image on
    // original image
    labelAnalysis1.inLabelImage.connectFrom(labelFilter.outLabelImage);
    labelAnalysis1.inIntensityImage.setValue(imageAdapter);
    labelAnalysis2.inLabelImage.connectFrom(labelFilter.outLabelImage);
    labelAnalysis2.inIntensityImage.setValue(imageAdapter);

    // 10- Display the Ferret ratio computed on the most elongated particle
    // 10- . Default ratio: With the default configuration of Feret angles
    // 10- . Custom ratio : With the customized configuration of Feret angles
    // (more precise)
    SoLabelAnalysisResult analysis1 = labelAnalysis1.outAnalysis.getValue();
    SoLabelAnalysisResult analysis2 = labelAnalysis2.outAnalysis.getValue();
    System.out.println("Particle 11 (the elongated one) : ");
    System.out.println("\t - Default ratio = " + analysis1.getValueAsString(10, 0, 0));
    System.out.println("\t - Custom ratio  = " + analysis2.getValueAsString(10, 0, 0));

    myRenderArea.setSceneGraph(root);
    myRenderArea.viewAll();

    final Component component = myRenderArea.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myRenderArea.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("ImageViz - Custom Attribute");
  }
}
