package imageviz.gettingstarted.customMeasure;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.imageviz.SbImageDataAdapterHelper;
import com.openinventor.imageviz.engines.imageanalysis.individualmeasures.SoLabelAnalysisQuantification;
import com.openinventor.imageviz.engines.imagesegmentation.labeling.SoLabelingProcessing;
import com.openinventor.imageviz.nodes.analysis.SoLabelAnalysisResult;
import com.openinventor.imageviz.nodes.images.SoImageDataAdapter;
import com.openinventor.imageviz.nodes.images.SoImageDataAdapter.Interpretations;
import com.openinventor.imageviz.nodes.images.SoVRImageDataReader;
import com.openinventor.imageviz.nodes.measures.SoDataMeasureCustom;
import com.openinventor.imageviz.nodes.measures.SoDataMeasurePredefined;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.nodes.SoDataRange;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoOrthoSlice;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeShape;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private static final String filename = "$OIVJHOME/data/imageviz/polystyrene.separated.tif";
  private static final String labelColormap = "$OIVJHOME/data/imageviz/colormaps/labels256.am";

  private IViewerExaminer myRenderArea;

  @Override
  public void start()
  {
    myRenderArea = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = new SoSeparator();

    // 1- Instantiate the appropriate image adapter using SoFileDataAdapter
    SoImageDataAdapter imageAdapter = SbImageDataAdapterHelper.getAppropriateAdapter(filename);
    imageAdapter.interpretation.setValue(Interpretations.BINARY);

    // 2- Apply a label processing engine on our image
    SoLabelingProcessing labelFilter = new SoLabelingProcessing();
    labelFilter.inObjectImage.setValue(imageAdapter);

    // 3- Use a Volume reader to read the labelled image
    SoVRImageDataReader filteredImageReader = new SoVRImageDataReader();
    filteredImageReader.imageData.connectFrom(labelFilter.outLabelImage);

    // 4- Give this reader as data input to the volume data
    SoVolumeData volumeLabelImage = new SoVolumeData();
    volumeLabelImage.setReader(filteredImageReader);

    // 5- Define the colormap we want to use. In our case
    // 5- We load it from the labelColormap file
    SoTransferFunction transFunc = new SoTransferFunction();
    transFunc.loadColormap(labelColormap);

    // 6- Node in charge of drawing the volume
    SoOrthoSlice orthoSlice = new SoOrthoSlice();
    orthoSlice.interpolation.setValue(SoVolumeShape.Interpolations.NEAREST);

    // 7- Add a Data Range to be sure to map data properly
    SoDataRange dataRange = new SoDataRange();
    dataRange.min.setValue(0);
    dataRange.max.setValue(255);

    // 8- Build a simple scenegraph
    // 8- Note: SoOrthoSlice must appear after the SoVolumeData node.
    root.addChild(volumeLabelImage);
    root.addChild(dataRange);
    root.addChild(transFunc);
    root.addChild(orthoSlice);

    // 9- Separately use some SoLabelAnalysisQuantification
    SoLabelAnalysisQuantification labelAnalysis = new SoLabelAnalysisQuantification();

    // 9.1- Specify a custom circularity factor (values between 0 and 1) to be
    // performed
    SoDataMeasureCustom myMeasure = new SoDataMeasureCustom();
    myMeasure.measureName.setValue("myCircularity");
    myMeasure.formula.setValue("1.0/Sqrt("
        + SoDataMeasurePredefined.getName(SoDataMeasurePredefined.PredefinedMeasures.SHAPE_FACTOR_AP_2D) + ")");
    labelAnalysis.measureList.set1Value(0, myMeasure);

    // 9.2- Plug input on the Label engine output and intensity image on
    // original image
    labelAnalysis.inLabelImage.connectFrom(labelFilter.outLabelImage);
    labelAnalysis.inIntensityImage.setValue(imageAdapter);

    // 10- Display the analysis results regarding the identified cells with 2
    // decimal digits
    SoLabelAnalysisResult analysis = labelAnalysis.outAnalysis.getValue();
    for ( long i = 0; i < analysis.getNumLabels(); ++i )
    {
      // 10- analysis->getValueAsString(param1, param2, param3) allows
      // retrieving computed values
      // 10- Param1: is the number of the cell we want info about
      // 10- Param2: is the number of the measure we want to retrieve (0 is
      // Diameter, 1 aspect ratio
      // 10- according to the properties set earlier in 9.1)
      // 10- Param3: not used here. Set to 0
      System.out.println("Particle " + (i + 1));
      System.out.println("\t Custom factor = " + analysis.getValueAsString((int) i, 0, 0));
    }

    myRenderArea.setSceneGraph(root);
    myRenderArea.viewAll();

    final Component component = myRenderArea.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myRenderArea.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("ImageViz - Custom Measure");
  }
}
