package imageviz.gettingstarted.denoisingImage2D;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.imageviz.SbImageDataAccessor;
import com.openinventor.imageviz.SbImageDataAccessor.SubVolumeRegion;
import com.openinventor.imageviz.SbImageDataAdapterHelper;
import com.openinventor.imageviz.engines.SoImageVizEngine.ComputeModes;
import com.openinventor.imageviz.engines.imagefiltering.smoothinganddenoising.SoMedianFilterProcessing;
import com.openinventor.imageviz.engines.imagefiltering.smoothinganddenoising.SoMedianFilterProcessing.KernelTypes;
import com.openinventor.imageviz.nodes.images.SoImageDataAdapter;
import com.openinventor.imageviz.nodes.images.SoMemoryDataAdapter;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.fields.SoSFImage;
import com.openinventor.inventor.nodes.SoImageBackground;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private static final String filename = "$OIVJHOME/data/imageviz/autorad.tif";

  private IViewerExaminer myRenderArea;

  @Override
  public void start()
  {
    myRenderArea = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = new SoSeparator();

    // 1- Instantiate the appropriate image adapter using SoFileDataAdapter
    SoImageDataAdapter imageAdapter = SbImageDataAdapterHelper.getAppropriateAdapter(filename);

    // 2- Image Processing step: median denoising filter.
    SoMedianFilterProcessing medianFilter = new SoMedianFilterProcessing();
    medianFilter.inImage.setValue(imageAdapter);
    medianFilter.computeMode.setValue(ComputeModes.MODE_2D);
    medianFilter.kernelType.setValue(KernelTypes.STANDARD);
    medianFilter.elementSize.setValue(5);

    // 3- Display the filtered image
    // 3-1 Create a memory data adapter of the computed image.
    SoImageDataAdapter image = medianFilter.outImage.getValue();
    SubVolumeRegion fullRegion = SbImageDataAccessor.createFullRegion(image);
    SoMemoryDataAdapter memoryImage = image.getDataAccessor().copyRegion(fullRegion);

    // 3-2 Set the memory data in a background object
    SbVec2i32 imageSize = new SbVec2i32(memoryImage.getSize().getX(), memoryImage.getSize().getY());
    SoImageBackground imageBackground = new SoImageBackground();
    imageBackground.style.setValue(SoImageBackground.Styles.CENTER);
    imageBackground.image.setValue(imageSize, memoryImage.getImageDataType().getNumChannel(),
        SoSFImage.DataTypes.valueOf(imageAdapter.getImageDataType().getDataType().getType().getValue()),
        memoryImage.getBufferObject(), SoSFImage.CopyPolicies.NO_COPY);

    // 4- Element for the scene graph
    // 4- Create a flat cube to support the texture
    // 4- Element for the scene graph
    root.addChild(imageBackground);

    myRenderArea.setSceneGraph(root);
    myRenderArea.viewAll();

    final Component component = myRenderArea.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myRenderArea.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("ImageViz - Denoising Image 2D");
  }
}
