package imageviz.gettingstarted.denoisingImage3D;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.imageviz.SbImageDataAdapterHelper;
import com.openinventor.imageviz.engines.SoImageVizEngine.ComputeModes;
import com.openinventor.imageviz.engines.imagefiltering.smoothinganddenoising.SoBilateralFilterProcessing;
import com.openinventor.imageviz.nodes.images.SoImageDataAdapter;
import com.openinventor.imageviz.nodes.images.SoVRImageDataReader;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private static final String filename = "$OIVJHOME/data/imageviz/eagleFordShale.am";

  private IViewerExaminer myRenderArea;

  @Override
  public void start()
  {
    myRenderArea = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = new SoSeparator();

    // 1- Instantiate the appropriate image adapter using SoFileDataAdapter
    SoImageDataAdapter imageAdapter = SbImageDataAdapterHelper.getAppropriateAdapter(filename);

    // 2- Define Bilateral denoising filter.
    SoBilateralFilterProcessing bilateralFilter = new SoBilateralFilterProcessing();
    bilateralFilter.inImage.setValue(imageAdapter);
    bilateralFilter.computeMode.setValue(ComputeModes.MODE_3D);
    bilateralFilter.kernelSize.setValue(new SbVec3i32(5, 5, 5));

    // 3- Create Readers/VolumeData for the computed image.
    SoVRImageDataReader inputImageReader = new SoVRImageDataReader();
    inputImageReader.imageData.connectFrom(bilateralFilter.outImage);
    SoVolumeData volumeFilteredImage = new SoVolumeData();
    volumeFilteredImage.setReader(inputImageReader);

    // 4- Element for the scene graph
    // 4- Now the main connection have been made, we need to build a scene graph
    // 4- to render the data.
    SoVolumeRender volRender = new SoVolumeRender();

    // 5- With a grayscale colormap
    SoTransferFunction colorMap = new SoTransferFunction();
    colorMap.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.INTENSITY);
    root.addChild(volumeFilteredImage);
    root.addChild(colorMap);
    root.addChild(volRender);

    myRenderArea.setSceneGraph(root);
    myRenderArea.viewAll();

    final Component component = myRenderArea.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myRenderArea.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("ImageViz - Denoising Image 3D");
  }
}
