package imageviz.gettingstarted.extractingROI;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.imageviz.SbChannelList;
import com.openinventor.imageviz.SbImageDataAccessor;
import com.openinventor.imageviz.SbImageDataAccessor.SubVolumeRegion;
import com.openinventor.imageviz.SbImageDataAdapterHelper;
import com.openinventor.imageviz.nodes.images.SoImageDataAdapter;
import com.openinventor.imageviz.nodes.images.SoMemoryDataAdapter;
import com.openinventor.imageviz.nodes.images.SoVRImageDataReader;
import com.openinventor.inventor.SbBox3i32;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoOrthoSlice;
import com.openinventor.volumeviz.nodes.SoVolumeData;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private static final String filename = "$OIVJHOME/data/imageviz/polystyrene.tif";

  private IViewerExaminer myRenderArea;

  @Override
  public void start()
  {
    myRenderArea = ViewerComponentsFactory.createViewerExaminer();

    // 1- Instantiate the appropriate image adapter using SoFileDataAdapter
    SoImageDataAdapter imageAdapter = SbImageDataAdapterHelper.getAppropriateAdapter(filename);

    // SbImageDataAccessor implement various predefined region.
    // SbSubVolumeRegion for instance represent a 3D box of an image. Bounds are
    // included, meaning here
    // we define the region [30, 100]x[30, 100]x[0, 0] of the image.
    // Note that a single 2D image is considered as an image stack containing 1
    // slice.
    SubVolumeRegion subVolumeRegion = new SbImageDataAccessor.SubVolumeRegion(new SbBox3i32(30, 30, 0, 100, 100, 0));

    // SbChannelList represent a list of channel. SbChannelList::RGB is a
    // shortcup for accessing
    // to channels {0, 1, 2}.
    SbChannelList channelList = new SbChannelList(3);

    // getDataAccessor() return the SbImageDataAccessor associated to this
    // ImageDataAdapter. Thanks to SbImageDataAccessor class,
    // you can access to a single voxel, sub regions like line, slice, trace or
    // the whole image.
    //
    // Using the SbImageDataAccessor, we can copy data of specified region in
    // memory to create an SoImageBuffer.
    // SoImageBuffer data are resident in memory. Be careful to not request too
    // much data to avoid saturate your system memory.
    //
    // You can request for data that are actually outside of the image, or
    // request for channel that are not in image.
    // SbImageDataAccessor consider that any value outside of image is zeros. In
    // the same way, if you request the 3rd channel
    // of a single channel image, the returned value will be zeros.
    SoMemoryDataAdapter subImage = imageAdapter.getDataAccessor().copyRegion(subVolumeRegion, channelList);

    // Now we can use this sub-region as input to an engine or directly save it
    // to a file.
    String outputFile = "$OIVJHOME/examples/imageviz/gettingstarted/extractingROI/polystyreneROI.tif";
    SbImageDataAdapterHelper.saveToFile(subImage, outputFile);
    System.out.println("Output saved to " + outputFile);

    SoVRImageDataReader roiReader = new SoVRImageDataReader(subImage);
    SoVolumeData roiImage = new SoVolumeData();
    roiImage.setReader(roiReader);

    SoTransferFunction colorMap = new SoTransferFunction();
    colorMap.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.INTENSITY);

    SoSeparator root = new SoSeparator();
    root.addChild(roiImage);
    root.addChild(colorMap);
    root.addChild(new SoOrthoSlice());

    myRenderArea.setSceneGraph(root);
    myRenderArea.viewAll();

    final Component component = myRenderArea.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myRenderArea.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("ImageViz - Extracting ROI");
  }
}
