package imageviz.gettingstarted.floodFillSegmentation;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.imageviz.SbImageDataAdapterHelper;
import com.openinventor.imageviz.engines.imagesegmentation.featureselection.SoObjectBoundariesProcessing;
import com.openinventor.imageviz.engines.imagesegmentation.regiongrowing.SoFloodFillThresholdProcessing;
import com.openinventor.imageviz.nodes.images.SoImageDataAdapter;
import com.openinventor.imageviz.nodes.images.SoVRImageDataReader;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoOrthoSlice;
import com.openinventor.volumeviz.nodes.SoVolumeData;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private static final String filename = "$OIVJHOME/data/imageviz/autorad.tif";

  private IViewerExaminer myRenderArea;

  @Override
  public void start()
  {
    myRenderArea = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = new SoSeparator();

    // 1- Instantiate the appropriate image adapter using SoFileDataAdapter
    SoImageDataAdapter imageAdapter = SbImageDataAdapterHelper.getAppropriateAdapter(filename);

    // 2- Apply thresholding to get a binarization
    // 2.1- instantiate the engine and connect it to input image data
    SoFloodFillThresholdProcessing thresholdProcess = new SoFloodFillThresholdProcessing();
    thresholdProcess.inImage.setValue(imageAdapter);
    // 2.2- Define parameters of the engine:
    // 2.2.1- Select the seed pixel to start the flood filling
    // 2.2.1- We set here the center of the image since it is inside the slice
    // we want to segment.
    // 2.2.1- This tool is devoted to be used in an interactive way.
    // 2.2.1- Please refer to the MarkerPicking demo to learn how to select
    // interactively the seed point.
    thresholdProcess.seedPoint
        .setValue(new SbVec3i32(imageAdapter.getSize().getX() / 2, imageAdapter.getSize().getY() / 2, 1));
    // 2.2.2- Select pixels connected to the seed with intensity between 0 and
    // 210
    thresholdProcess.thresholdLevel.setValue(new SbVec2f(0, 210));

    // 2.3- Compute the boundaries of the thresholding result
    SoObjectBoundariesProcessing boundaryProcess = new SoObjectBoundariesProcessing();
    boundaryProcess.inObjectImage.connectFrom(thresholdProcess.outBinaryImage);

    // 3- Display the thresholded image over the original image
    // 3- Two pairs of Readers/VolumeData are needed here.
    // 3.1- One to render the original image.
    SoVRImageDataReader inputImageReader = new SoVRImageDataReader();
    inputImageReader.imageData.setValue(imageAdapter);
    SoVolumeData volumeInputImage = new SoVolumeData();
    volumeInputImage.setReader(inputImageReader);

    // 3.2- One to render the computed image.
    // 3.2- Directly connect this reader to the output of the filter
    SoVRImageDataReader filteredImageReader = new SoVRImageDataReader();
    filteredImageReader.imageData.connectFrom(boundaryProcess.outObjectImage);
    SoVolumeData volumeThresholdImage = new SoVolumeData();
    volumeThresholdImage.setReader(filteredImageReader);

    // 3.3- Element for the scene graph
    // 3.3- Now the main connection have been made, we need to build a scene
    // graph
    // 3.3- to render the data.

    // 3.3.1- Use a simple orthoslice
    SoOrthoSlice orthoSlice1 = new SoOrthoSlice();
    // 3.3.1- With a grayscale colormap
    SoTransferFunction colorMap1 = new SoTransferFunction();
    colorMap1.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.INTENSITY);
    root.addChild(volumeInputImage);
    root.addChild(colorMap1);
    root.addChild(orthoSlice1);

    // 3.3.2- Node in charge of drawing the binary boundary image.
    // 3.3.2- Use a simple orthoslice
    SoOrthoSlice orthoSlice2 = new SoOrthoSlice();
    // 3.3.2- With a colormap to display pixels of intensity 1 in blue
    SoTransferFunction colorMap2 = new SoTransferFunction();
    colorMap2.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.BLUE_RED);
    colorMap2.minValue.setValue(1);
    colorMap2.maxValue.setValue(1);
    root.addChild(volumeThresholdImage);
    root.addChild(colorMap2);
    root.addChild(orthoSlice2);

    myRenderArea.setSceneGraph(root);
    myRenderArea.viewAll();

    final Component component = myRenderArea.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myRenderArea.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("ImageViz - FloodFill Segmentation");
  }
}
