package imageviz.workflow.registration;

import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoTransform;

public class ASyncTransformation implements Runnable
{
  SoTransform m_transform;
  SbVec3f m_translation = new SbVec3f();
  SbRotation m_rotation = new SbRotation();
  SbVec3f m_scaleFactor = new SbVec3f();
  SbRotation m_scaleOrientation = new SbRotation();
  SbVec3f m_center = new SbVec3f();

  public ASyncTransformation(SoTransform transform)
  {
    m_transform = transform;
  }

  public void setValues(SbVec3f translation, SbRotation rotation, SbVec3f scaleFactor, SbRotation scaleOrientation,
      SbVec3f center)
  {
    m_translation.setValue(translation);
    m_rotation.setValue(rotation);
    m_scaleFactor.setValue(scaleFactor);
    m_scaleOrientation.setValue(scaleOrientation);
    m_center.setValue(center);
  }

  public void run()
  {
    m_transform.translation.setValue(m_translation);
    m_transform.rotation.setValue(m_rotation);
    m_transform.scaleFactor.setValue(m_scaleFactor);
    m_transform.scaleOrientation.setValue(m_scaleOrientation);
    m_transform.center.setValue(m_center);
  }

}
