#version 330 compatibility

// The type of the sampler is defined according to the layout of the texture3
// sampler3D for Volume, sampler2DArray for Array
uniform sampler3D rgbaTexture3d;
uniform sampler2DArray rgbaTexture2dArray;

// The type of the SoTexture3, 0 for Volume, 1 for Array
uniform int tex_layout_type;

in vec3 vPos;

bool
isAlmostEqual ( in float a, in float b )
{
  return (abs(a - b) < 1e-2);
}

void
main ()
{
  int face = 0;
  vec2 texCoord = vec2(0.0);
  
  if ( isAlmostEqual(vPos.z, 1.0) )
  {
    face = 0;
    texCoord = vPos.xy;
  }
  else if ( isAlmostEqual(vPos.y, 1.0) )
  {
    face = 1;
    texCoord = vPos.xz;
  }
  else if ( isAlmostEqual(vPos.x, 1.0) )
  {
    face = 2;
    texCoord = vPos.yz;
  }
  else if ( isAlmostEqual(vPos.z, -1.0) )
  {
    face = 3;
    texCoord = vPos.xy;
  }
  else if ( isAlmostEqual(vPos.y, -1.0) )
  {
    face = 4;
    texCoord = vPos.xz;
  }
  else // if ( isAlmostEqual(vPos.x, -1.0) )
  {
    face = 5;
    texCoord = vPos.yz;
  }

  if ( any(greaterThanEqual(abs(texCoord), vec2(0.98))) )
  {
    gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
  }
  else
  {
    texCoord *= 0.5;
    texCoord += 0.5;
    if ( tex_layout_type == 0 )
      gl_FragColor = texture(rgbaTexture3d, vec3(texCoord, (face + 0.5) / 6.0 ));
    else if ( tex_layout_type == 1 )
      gl_FragColor = texture(rgbaTexture2dArray, vec3(texCoord, face));
    else
      gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
  }
}
