package inventor.advanced.algebraicshape.customcomputecolor;

/*
 * This example demonstrates how to implement custom color shader slot for
 * a SoAlgebraicShape by providing a shader file corresponding to a custom
 * shading per fragment. Moreover, it provides an example on how to handle
 * a texture by computing fake texture coordinates and use a texture embedded
 * in the scene graph. It also shows how to generate transparent fragment
 * without setting a transparent material.
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;

import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.actions.SoGLRenderAction.TransparencyTypes;
import com.openinventor.inventor.nodes.SoAlgebraicSphere;
import com.openinventor.inventor.nodes.SoFragmentShader;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoShaderParameter1i;
import com.openinventor.inventor.nodes.SoTexture2;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private IViewerExaminer m_myViewer;

  @Override
  public void start()
  {
    m_myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Add path to find our data
    SoInput.addDirectoryFirst(getDataPath() + "textures");
    SoInput.addDirectoryFirst(getDataPath() + "shaders");
    SoSeparator sceneGraph = createSceneGraph();

    m_myViewer.setSceneGraph(sceneGraph);
    m_myViewer.getRenderArea().setTransparencyType(TransparencyTypes.SORTED_PIXELS_BLEND);
    m_myViewer.viewAll();

    // SWING part
    final Component component = m_myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    m_myViewer.dispose();
  }

  private SoSeparator createSceneGraph()
  {
    SoTexture2 texture = new SoTexture2();
    texture.filename.setValue("noise.png");

    // Create AlgebraicSphere with custom slot COMPUTE_COLOR
    SoAlgebraicSphere sphere = new SoAlgebraicSphere();

    // Explicitly specify that generated fragment color is transparent
    sphere.generateTransparency.setValue(true);

    // Fill COMPUTE_COLOR slot with custom shader
    sphere.shaderSlots.set1Value(0, configureShaders());

    SoSeparator scene = new SoSeparator();
    scene.addChild(new SoGradientBackground());
    scene.addChild(texture);
    scene.addChild(sphere);

    return scene;
  }

  private String getDataPath()
  {
    String pkgName = this.getClass().getPackage().getName();
    pkgName = pkgName.replace('.', File.separatorChar);
    return SoPreferences.getValue("OIVJHOME") + File.separator + "examples" + File.separator + pkgName + File.separator;
  }

  private SoFragmentShader configureShaders()
  {
    // Initialize and set the shader program
    SoFragmentShader fragment = new SoFragmentShader();
    fragment.sourceProgram.setValue("CustomComputeColor_frag.glsl");

    SoShaderParameter1i texParam = new SoShaderParameter1i();
    texParam.name.setValue("noiseTex");
    texParam.value.setValue(0);
    fragment.parameter.addShaderParameter(texParam);

    return fragment;
  }

  public static void main(String[] argv)
  {
    Main example = new Main();
    example.demoMain("Custom Algebraic Shape");
  }

}
