#version 330 compatibility

//!oiv_include <Inventor/oivAlgebraicShape.h>

uniform sampler2D noiseTex;
uniform mat4 OivViewMatrixInv;

const float Ka = 0.1;
const float Kd = 0.5;
const float Ks = 0.4;
const float shininess = 8.0;

const vec3 light0 = vec3(0.0, -1.0, 1.0);
const vec3 light1 = vec3(1.0, 1.0, 1.0);
const vec3 light2 = vec3(-1.0, 1.0, 1.0);
const vec3 light3 = vec3(-1.0, -1.0, 1.0);

vec3
phongShading ( in vec3 n, in vec3 v, in vec3 l, in vec3 c )
{
  // n dot l
  float NdL = max(dot(n, l), 0.0);

  // specular reflection
  vec3 r = reflect(-l, n);
  float specular = pow( max(dot(r, v), 0.0), shininess );

  // final composition
  return min((Ka + Kd*NdL)*c + Ks*specular, 1.0);
}

vec2
cartesian2polar ( in vec3 cartesian )
{
  return vec2( acos(cartesian.z), atan(cartesian.y/cartesian.x) );
}

vec4
OivASComputeColor ( in OivASPoint p )
{
  // compute texture coordinate
  vec4 tmp = OivViewMatrixInv*vec4(p.position, 1.0);
  vec2 texcoord = cartesian2polar(tmp.xyz);

  // color from texture
  vec4 c = texture(noiseTex, texcoord).rgba;
  if ( c.a < 0.05 )
    return c;

  vec3 n = normalize(p.normal) ;
  vec3 v = normalize(-p.position);

  // directional lights
  vec3 l0 = normalize(light0);
  vec3 l1 = normalize(light1);

  // point lights
  vec3 l2 = normalize((OivViewMatrixInv*vec4(light2, 1.0)).xyz);
  vec3 l3 = normalize((OivViewMatrixInv*vec4(light3, 1.0)).xyz);

  // lighting
  vec4 finalColor = vec4(1.0);
  finalColor.rgb = phongShading(n, v, l0, c.rgb);
  finalColor.rgb += phongShading(n, v, l1, c.rgb);
  finalColor.rgb += phongShading(n, v, l2, c.rgb);
  finalColor.rgb += phongShading(n, v, l3, c.rgb);
  finalColor.rgb *= 0.25;
  finalColor.a = c.a*OivASGetOpacity();

  return finalColor;
}
