
//!oiv_include <Inventor/oivAlgebraicShape.h>

// sampler <-> colormap
uniform sampler2D colorMap;

// index from vertex shader
flat in float oivColorMapIndex;


vec4
OivASComputeColor ( in OivASPoint p )
{
    // directional light
    vec3 l = normalize(gl_LightSource[0].position.xyz);

    // cosine shading
    float NdL = max(dot(p.normal, l), 0.0);

    // specular
    vec3 r = reflect(-l, p.normal);
    float spec = pow(max(dot(r, vec3(0.0, 0.0, 1.0)), 0.0), 16.0);
	
    vec4 color = texture(colorMap, vec2(oivColorMapIndex, 0.0)).rgba;
	
    return vec4((0.3 + 0.5*NdL)*color.rgb + 0.2*spec, OivASGetOpacity());
}
