package inventor.advanced.shaders.AnimatedFlag;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.border.*;

import com.openinventor.inventor.nodes.SoShaderObject;
import com.openinventor.inventor.nodes.SoVertexShader;

public class UserInterface {
  private JPanel    m_mainPanel;
  private JPanel    m_leftPanel;
  private Main       m_ivPanel;

  public UserInterface(Main iv_panel) {
    m_ivPanel = iv_panel;
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  public JPanel getMainPanel() {
    return m_mainPanel;
  }

  private void jbInit() throws Exception {
    JCheckBox jCheckAnim = new JCheckBox();
    jCheckAnim.addItemListener(new jCheckAnim());
    jCheckAnim.setEnabled(true);
    jCheckAnim.setToolTipText("animate flag with wind effect");
    jCheckAnim.setVerifyInputWhenFocusTarget(true);
    jCheckAnim.setSelected(true);
    jCheckAnim.setText("Anim flag");

    JRadioButton jCheckARB = new JRadioButton();
    jCheckARB.setToolTipText("use ARB shader program");
    jCheckARB.setEnabled(SoVertexShader.isSupported(SoShaderObject.SourceTypes.ARB_PROGRAM));
    jCheckARB.setSelected(false);
    jCheckARB.setText("ARB");
    jCheckARB.addItemListener(new jCheckShaderLanguage(SoShaderObject.SourceTypes.ARB_PROGRAM.getValue()));

    JRadioButton jCheckCG = new JRadioButton();
    jCheckCG.setToolTipText("use CG shader program");
    jCheckCG.setEnabled(SoVertexShader.isSupported(SoShaderObject.SourceTypes.CG_PROGRAM));
    jCheckCG.setSelected(false);
    jCheckCG.setText("CG");
    jCheckCG.addItemListener(new jCheckShaderLanguage(SoShaderObject.SourceTypes.CG_PROGRAM.getValue()));

    JRadioButton jCheckGLSL = new JRadioButton();
    jCheckGLSL.setToolTipText("use GLSL shader program");
    jCheckGLSL.setEnabled(SoVertexShader.isSupported(SoShaderObject.SourceTypes.GLSL_PROGRAM));
    jCheckGLSL.setSelected(true);
    jCheckGLSL.setText("GLSL");
    jCheckGLSL.addItemListener(new jCheckShaderLanguage(SoShaderObject.SourceTypes.GLSL_PROGRAM.getValue()));

    //Group the radio buttons.
    ButtonGroup group = new ButtonGroup();
    group.add(jCheckARB);
    group.add(jCheckCG);
    group.add(jCheckGLSL);

    TitledBorder titledBorder = new TitledBorder(new EtchedBorder(EtchedBorder.RAISED,
        Color.white, new Color(148, 145, 140)), "Shader");

    JPanel jProjectedTexturePanel = new JPanel();
    jProjectedTexturePanel.setBorder(titledBorder);
    jProjectedTexturePanel.add(jCheckARB);
    jProjectedTexturePanel.add(jCheckCG);
    jProjectedTexturePanel.add(jCheckGLSL);

    m_leftPanel = new JPanel();
    m_leftPanel.add(jCheckAnim);
    m_leftPanel.add(jProjectedTexturePanel);

    m_mainPanel = new JPanel();
    m_mainPanel.add(m_leftPanel);

    SpringLayout left_layout = new SpringLayout();
    left_layout.putConstraint(SpringLayout.NORTH, jCheckAnim, 20,
                              SpringLayout.NORTH, jCheckAnim.getParent());
    left_layout.putConstraint(SpringLayout.WEST, jCheckAnim, 5,
                              SpringLayout.WEST, jCheckAnim.getParent());
    left_layout.putConstraint(SpringLayout.NORTH, jProjectedTexturePanel, 30,
                              SpringLayout.SOUTH, jCheckAnim);
    left_layout.putConstraint(SpringLayout.WEST, jProjectedTexturePanel, 5,
                              SpringLayout.WEST,
                              jProjectedTexturePanel.getParent());
    left_layout.putConstraint(SpringLayout.EAST,
                              jProjectedTexturePanel.getParent(), 5,
                              SpringLayout.EAST, jProjectedTexturePanel);
    left_layout.putConstraint(SpringLayout.SOUTH,
                              jProjectedTexturePanel.getParent(), 5,
                              SpringLayout.SOUTH, jProjectedTexturePanel);

    SpringLayout ptex_layout = new SpringLayout();
    ptex_layout.putConstraint(SpringLayout.NORTH, jCheckARB, 5,
                              SpringLayout.NORTH, jCheckARB.getParent());
    ptex_layout.putConstraint(SpringLayout.WEST, jCheckARB, 5,
                              SpringLayout.WEST, jCheckARB.getParent());
    ptex_layout.putConstraint(SpringLayout.EAST, jCheckARB.getParent(),15,
                              SpringLayout.EAST, jCheckARB);

    ptex_layout.putConstraint(SpringLayout.NORTH, jCheckCG, 5,
                              SpringLayout.SOUTH, jCheckARB);
    ptex_layout.putConstraint(SpringLayout.WEST, jCheckCG, 5,
                              SpringLayout.WEST, jCheckCG.getParent());
    ptex_layout.putConstraint(SpringLayout.EAST, jCheckCG.getParent(),15,
                              SpringLayout.EAST, jCheckCG);

    ptex_layout.putConstraint(SpringLayout.NORTH, jCheckGLSL, 5,
                              SpringLayout.SOUTH, jCheckCG);
    ptex_layout.putConstraint(SpringLayout.WEST, jCheckGLSL, 5,
                              SpringLayout.WEST, jCheckGLSL.getParent());
    ptex_layout.putConstraint(SpringLayout.SOUTH, jCheckGLSL.getParent(), 15,
                              SpringLayout.SOUTH, jCheckGLSL);

    m_leftPanel.setLayout(left_layout);
    jProjectedTexturePanel.setLayout(ptex_layout);
  }

  class jCheckAnim implements java.awt.event.ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED)
        m_ivPanel.setAnim(true);
      else
        m_ivPanel.setAnim(false);
    }
  }

  class jCheckShaderLanguage implements java.awt.event.ItemListener {
    int shaderLanguage;
    jCheckShaderLanguage(int shaderLanguage) {
      this.shaderLanguage = shaderLanguage;
    }
    public void itemStateChanged(ItemEvent e) {
      m_ivPanel.setShaderLanguage(shaderLanguage);
    }
  }

}
