layout(triangles, equal_spacing, cw) in;
in vec4 tcPosition[];
out vec4 tePosition;
out vec3 tePatchDistance;
uniform mat4 OivModelMatrix;
uniform mat4 OivViewMatrix;
uniform mat4 OivProjectionMatrix;

void main()
{
  vec3 p0 = gl_TessCoord.x * tcPosition[0].xyz;
  vec3 p1 = gl_TessCoord.y * tcPosition[1].xyz;
  vec3 p2 = gl_TessCoord.z * tcPosition[2].xyz;

  //normalize to push the new verts onto the spheres surface
  tePosition = OivProjectionMatrix * OivViewMatrix * OivModelMatrix * vec4(normalize(p0 + p1 + p2), 1);
}
