package inventor.advanced.timerSensor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoRotation;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.sensors.SoTimerSensor;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
  * TimerSensor example program;
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  */


public class Main extends Example {

  private static String filename = null;
  private IViewerExaminer myViewer;
  private SoTimerSensor rotatingSensor;
  private SoTimerSensor schedulingSensor;

  public static void main (String [] argv) {
    if (argv.length != 1)
      filename = "$OIVJHOME/data/models/duck.iv";
    else
      filename = argv[0];

    Main example = new Main();
    example.demoMain("Timer Sensor");
  }

  @Override
  public void start()
  {
    start(filename);
  }

  private void start(String name) {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoInput inputFile = new SoInput();
    if ( name == null )
      inputFile.openFile("$OIVJHOME/data/models/duck.iv");
    else
      inputFile.openFile(name);

    SoRotation myRotation = new SoRotation();

    rotatingSensor = new SoTimerSensor(new RotatingSensorTask(myRotation));
    rotatingSensor.setInterval(new SbTime(1.0)); // scheduled once per second
    rotatingSensor.schedule();

    schedulingSensor = new SoTimerSensor(new SchedulingSensorTask());
    schedulingSensor.setInterval(new SbTime(5.0)); // once per 5 seconds
    schedulingSensor.schedule();


    // define the scene-graph root
    SoSeparator root = new SoSeparator();
    root.addChild(myRotation);
    root.addChild(SoDB.readAll(inputFile));

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    rotatingSensor.unschedule();
    schedulingSensor.unschedule();
    myViewer.dispose();
  }

  // inner classes to declare callbacks
  class RotatingSensorTask implements Runnable {

    private SoRotation myRotation;
    public RotatingSensorTask(SoRotation rot) { myRotation = rot; }

    @Override
    public void run() {
      // Rotate an object...
      SbRotation currentRotation = myRotation.rotation.getValue() ;
      currentRotation.multiply(new SbRotation(new SbVec3f(0,0,1), (float) Math.PI/90F)) ;
      myRotation.rotation.setValue(currentRotation) ;
    }
  }

  class SchedulingSensorTask implements Runnable {
    @Override
    public void run() {
      // This function is called once every 5 seconds, and
      // reschedules the other sensor.
      rotatingSensor.unschedule() ;
      if (rotatingSensor.getInterval().getMsecValue() == 1000)
	rotatingSensor.setInterval(new SbTime(0.1));
      else
	rotatingSensor.setInterval(new SbTime(1.0));
      rotatingSensor.schedule() ;
    }
  }
  // end of inner classes declaration

  public Main() {}

  public Panel makeError(String fileName) {
    Label error = new Label("An error has occured when trying to open the file "+fileName) ;
    Panel p = new Panel() ;
    p.add(error) ;
    return p ;
  }

}
