/*------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 16, example 3.
 *
 *  This example builds a render area in a window supplied by
 *  the application and a Material Editor in its own window.
 *  It attaches the editor to the material of an object.
 *-----------------------------------------------------------*/
package inventor.mentor.attachEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaExaminer;

import util.Example;
import util.ViewerComponentsFactory;
import util.editors.MaterialEditor;

public class Main extends Example {

  private IRenderAreaExaminer myRenderArea;
  private MaterialEditor myEditor;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Attach Editor");
  }

  @Override
  public void start() {
    myRenderArea = ViewerComponentsFactory.createRenderAreaExaminer();

    myEditor = new MaterialEditor();
    myEditor.setVisible(true);

    // Create a scene graph
    SoMaterial myMaterial = new SoMaterial();

    // Read the geometry from a file and add to the scene
    SoInput myInput = new SoInput();
    String filename = "$OIVJHOME/data/models/dogDish.iv";
    if (!myInput.openFile(filename)) {
      System.err.println("Cannot open file " + filename);
      System.exit(1);
    }
    SoSeparator geomObject = SoDB.readAll(myInput);
    if (geomObject == null) {
      System.err.println("Cannot read file " + filename);
      System.exit(1);
    }

    // Attach material editor to the material
    myEditor.attach(myMaterial);

    SoSeparator root = new SoSeparator();
    { // Assemble scene graph
      root.addChild(myMaterial);
      root.addChild(geomObject);
    }

    // Build the render area in the applications main window
    final Component canvas = myRenderArea.getComponent();
    canvas.setSize(new Dimension(200, 200));

    // Set the scene graph
    myRenderArea.setSceneGraph(root);
    myRenderArea.viewAll(new SbViewportRegion(canvas.getSize()));

    setLayout(new BorderLayout());
    add(canvas);
  }

  @Override
  public void stop()
  {
    myEditor.dispose();
    myRenderArea.dispose();
  }
}
