
package inventor.mentor.bezSurf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.nodes.* ;
import com.openinventor.inventor.viewercomponents.SoCameraInteractor;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
  * This is an example from the Inventor Mentor,
  * chapter 8, example 3.
  *
  * This example creates and displays a Bezier surface.
  * The surface is order 4 with 16 control points and U and V
  * knot vectors of length 8.  The knot vectors have two values
  * each with multipliciy 4 to define the Bezier surface.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */

public class Main extends Example {

  private IViewerExaminer viewer;

  public static void main(String [] argv) {
    Main example = new Main();
    example.demoMain("BezSurf");
  }

  @Override
  public void start() {
    viewer = ViewerComponentsFactory.createViewerExaminer();

    // Create the scene graph for the floor texture
    SoTexture2 floor_texture = new SoTexture2();
    floor_texture.filename.setValue("$OIVJHOME/data/textures/rgb/oak.rgb");

    // Create the scene graph for the floor
    URL url_floor = getURL(SoPreferences.getValue("OIVJHOME") + "/data/models/Floor.iv");
    if (url_floor == null) return;

    SoSeparator floor = new SoSeparator();
    SoTranslation  xlate = new SoTranslation();
    SoScale scale = new SoScale();

    SoInput in = new SoInput();
    in.openURL(url_floor);
    SoNode result = SoDB.readNode(in);
    xlate.translation.setValue(new SbVec3f(-12, -5, -5));
    scale.scaleFactor.setValue(new SbVec3f(2, 1, 2));
    {
      floor.addChild(xlate);
      floor.addChild(scale);
      floor.addChild(result);
    }

    // Create the scene graph for the carpet;
    SoSeparator carpet = new SoSeparator();
    SoSeparator surf = makeSurface();
    SoTexture2 tex = new SoTexture2();

    tex.filename.setValue("$OIVJHOME/data/textures/rgb/diamondRug.rgb");
    {
      carpet.addChild(tex);
      carpet.addChild(surf);
    }

    // Create the scene graph for the carpet's shadow
    SoSeparator shadow = new SoSeparator();
    SoLightModel shmdl = new SoLightModel();
    SoMaterial shmtl = new SoMaterial();
    SoBaseColor shclr = new SoBaseColor();
    SoTranslation shxl = new SoTranslation();
    SoScale shscl = new SoScale();

    shmdl.model.setValue(SoLightModel.Models.BASE_COLOR);
    shclr.rgb.setValue(new SbColor(0.21F, 0.15F, 0.09F));
    shmtl.transparency.setValue(0.3F);
    shxl.translation.setValue(new SbVec3f(0, -4.9F, 0));
    shscl.scaleFactor.setValue(new SbVec3f(1, 0.01F, 1));
    {
      shadow.addChild(shmtl);
      shadow.addChild(shmdl);
      shadow.addChild(shclr);
      shadow.addChild(shxl);
      shadow.addChild(shscl);
      shadow.addChild(surf);
    }

    SoRotation rot = new SoRotation();
    rot.rotation.setValue(new SbRotation(new SbVec3f(0, 1, 0), (float) (Math.PI/2)));

    SoSeparator root = new SoSeparator();
    { // assemble scene graph
      root.addChild(rot);
      root.addChild(carpet);
      root.addChild(floor_texture);
      root.addChild(floor);
      root.addChild(shadow);
    }

    viewer.setSceneGraph(root);
    SoCameraInteractor interactor = viewer.getRenderArea().getRootSceneGraph().getCameraInteractor();
    interactor.setPosition(new SbVec3f(-8.5F, 13, 23));
    interactor.pointAt(new SbVec3f(-2, -2, -4));

    final Component component = viewer.getComponent();
    component.setName("Bezier Surface");
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    viewer.dispose();
  }

  // Create the nodes needed for the Bezier surface.
  SoSeparator makeSurface() {
    // The control points for this surface
    float pts[][] = {
      {-4.5F, -2,  8},
      {-2,  1,  8},
      { 2, -3,  6},
      { 5, -1,  8},
      {-3,  3,  4},
      { 0, -1,  4},
      { 1, -1,  4},
      { 3,  2,  4},
      {-5, -2, -2},
      {-2, -4, -2},
      { 2, -1, -2},
      { 5,  0, -2},
      {-4.5F,  2, -6},
      {-2, -4, -5},
      { 2,  3, -5},
      { 4.5F, -2, -6}};

    // The knot vector
    float knots[] = {0, 0, 0, 0, 1, 1, 1, 1};

    SoSeparator surfSep = new SoSeparator();

    // Define the Bezier surface including the control
    // points and a complexity.
    SoComplexity complexity = new SoComplexity();
    SoCoordinate3 controlPts = new SoCoordinate3();
    SoNurbsSurface surface = new SoNurbsSurface();
    complexity.value.setValue(0.7F);
    controlPts.point.setValues(0, pts);
    surface.numUControlPoints.setValue(4);
    surface.numVControlPoints.setValue(4);
    surface.uKnotVector.setValues(0, knots);
    surface.vKnotVector.setValues(0, knots);
    surfSep.addChild(complexity);
    surfSep.addChild(controlPts);
    surfSep.addChild(surface);

    return surfSep;
  }

  private URL getURL(String fileName) {
    URL url = null;
    try {
      url = new URL("file:"+(new File(fileName)).getAbsolutePath()) ;
    }
    catch (MalformedURLException exc) {
      System.err.println(exc + " : (" + url + ") " + fileName + " invalid URL");
      url = null;
    }
    catch (Exception e) {
      System.err.println(e + " : cant load File "+ fileName);
      url = null;
    }
    return url;
  }

}

