/*------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 16, example 2.
 *
 *  This example builds a render area in a window supplied by
 *  the application and a Material Editor in its own window.
 *  It uses callbacks for the component to report new values.
 *----------------------------------------------------------*/

package inventor.mentor.callback;
import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoPerspectiveCamera;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaInteractive;

import util.Example;
import util.ViewerComponentsFactory;
import util.editors.MaterialEditor;

public class Main extends Example {

  MaterialEditor myEditor;
  private IRenderAreaInteractive myRenderArea;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Editor Callback");
  }

  @Override
  public void start() {
    myRenderArea = ViewerComponentsFactory.createRenderAreaInteractive();

    // Build the Material Editor in its own window
    myEditor = new MaterialEditor();
    myEditor.setVisible(true);

    // Read the geometry from a file and add to the scene
    SoInput myInput = new SoInput();
    String filename = "$OIVJHOME/data/models/dogDish.iv";
    if (!myInput.openFile(filename)) {
      System.err.println("Cannot open file " + filename);
      System.exit(1);
    }
    SoSeparator geomObject = SoDB.readAll(myInput);
    if (geomObject == null) {
      System.err.println("Cannot read file " + filename);
      System.exit(1);
    }

    SoPerspectiveCamera myCamera = (SoPerspectiveCamera) myRenderArea.getRootSceneGraph().getCamera();
    myCamera.position.setValue(0.212482f, -0.881014f, 2.5f);
    myCamera.heightAngle.setValue((float)(Math.PI/4.0f));

    // Add a callback for when the material changes
    SoMaterial myMaterial = new SoMaterial();
    myEditor.addListener(new MaterialEditorListener(myMaterial));

    // Create a scene graph
    SoSeparator root = new SoSeparator();
    { // Assemble scene graph
      root.addChild(myMaterial);
      root.addChild(geomObject);
    }

    // Set the scene graph
    myRenderArea.setSceneGraph(root);

    final Component canvas = myRenderArea.getComponent();
    canvas.setSize(200, 200);
    setLayout(new BorderLayout());
    add(canvas);
  }

  @Override
  public void stop()
  {
    myEditor.dispose();
    myRenderArea.dispose();
  }

  class MaterialEditorListener extends MaterialEditor.Listener {
    SoMaterial m_material;

    public MaterialEditorListener(SoMaterial mat) {
      m_material = mat;
    }

    @Override
    public void valueChanged(SoMaterial material)
    {
      // Copy all the fields from the new material
      m_material.copyFieldValues(material);
    }
  }
}
