/*----------------------------------------------------------------
 *  This is an example from the Inventor Mentor.
 *  chapter 15, example 1.
 *
 *  Uses an SoTranslate1Dragger to control the bottomRadius field
 *  of an SoCone.  The 'translation' field of the dragger is the
 *  input to an SoDecomposeVec3f engine. The engine extracts the
 *  x component from the translation. This extracted value is
 *  connected to the bottomRadius field of the cone.
 *----------------------------------------------------------------*/

package inventor.mentor.coneRadius;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.draggers.SoTranslate1Dragger;
import com.openinventor.inventor.engines.SoDecomposeVec3f;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoTransform;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example {

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Dragger Edits Cone Radius");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Create myDragger with an initial translation of (1, 0, 0)
    SoTranslate1Dragger myDragger = new SoTranslate1Dragger();
    myDragger.translation.setValue(1, 0, 0);

    // Place an SoCone above myDragger
    SoTransform myTransform = new SoTransform();
    SoCone myCone = new SoCone();
    myTransform.translation.setValue(0, 3, 0);

    // SoDecomposeVec3f engine extracts myDragger's x-component
    // The result is connected to myCone's bottomRadius.
    SoDecomposeVec3f myEngine = new SoDecomposeVec3f();
    myEngine.vector.connectFrom(myDragger.translation);
    myCone.bottomRadius.connectFrom(myEngine.x);

    SoSeparator root = new SoSeparator();
    { // Assemble scene graph
      root.addChild(myDragger);
      root.addChild(myTransform);
      root.addChild(myCone);
    }

    // Display them in a viewer
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
