/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor
 *  chapter 13, example 3.
 *
 *  Elapsed time engine.
 *  The output from an elapsed time engine is used to control
 *  the translation of the object.  The resulting effect is
 *  that the figure slides across the scene.
 *------------------------------------------------------------*/

package inventor.mentor.elapsedTime;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.engines.SoComposeVec3f;
import com.openinventor.inventor.engines.SoElapsedTime;
import com.openinventor.inventor.nodes.SoPerspectiveCamera;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoTransform;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaInteractive;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example {

  private IRenderAreaInteractive myRenderArea;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Sliding Man");
  }

  @Override
  public void start() {
    myRenderArea = ViewerComponentsFactory.createRenderAreaInteractive();

    // Setup camera
    SoPerspectiveCamera myCamera = (SoPerspectiveCamera) myRenderArea.getRootSceneGraph().getCamera();
    myCamera.position.setValue(-2.0f, -2.0f, 5.0f);
    myCamera.heightAngle.setValue((float)(Math.PI/2.5f));
    myCamera.nearDistance.setValue(2.0f);
    myCamera.farDistance.setValue(7.0f);

    // Set up transformations
    SoTranslation slideTranslation = new SoTranslation();
    SoTransform initialTransform = new SoTransform();
    initialTransform.translation.setValue(-5.0f, 0.0f, 0.0f);
    initialTransform.scaleFactor.setValue(10.0f, 10.0f, 10.0f);
    initialTransform.rotation.setValue(new SbVec3f(1.0f, 0.0f, 0.0f),
                                       (float)(Math.PI/2.0f));

    // Read the figure object from a file and add to the scene
    SoInput myInput = new SoInput();
    String filename = "$OIVJHOME/data/models/jumpyMan.iv";
    if (!myInput.openFile(filename)) {
      System.err.println("Cannot open file " +  filename);
      System.exit(1);
    }
    SoSeparator figureObject = SoDB.readAll(myInput);
    if (figureObject == null) {
      System.err.println("Cannot read file " +  filename);
      System.exit(1);
    }

    // Make the X translation value change over time.
    SoElapsedTime myCounter = new SoElapsedTime();
    SoComposeVec3f slideDistance = new SoComposeVec3f();
    slideDistance.x.connectFrom(myCounter.timeOut);
    slideTranslation.translation.connectFrom(slideDistance.vector);

    SoSeparator root = new SoSeparator();
    { // Assemble scene graph
      root.addChild(slideTranslation);
      root.addChild(initialTransform);
      root.addChild(figureObject);
    }

    myRenderArea.setSceneGraph(root);

    final Component canvas = myRenderArea.getComponent();
    canvas.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(canvas);
  }

  @Override
  public void stop()
  {
    myRenderArea.dispose();
  }
}
