/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 12, example 1.
 *
 *  Sense changes to a viewer's camera's position.
 *------------------------------------------------------------*/
package inventor.mentor.fieldSensor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.sensors.SoFieldSensor;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example {

  private IViewerExaminer myViewer;
  private String m_filename;
  private JTextArea m_txtArea;
  private SoFieldSensor m_fieldSensor;

  public Main() {
    m_txtArea = new JTextArea();
    m_filename = "$OIVJHOME/data/models/toys/jackInTheBox.iv";
  }

  public static void main(String[] args) {
    Main example = new Main();
    if (args.length > 0)
      example.m_filename = args[0];
    example.demoMain("Camera Sensor");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoInput inputFile = new SoInput();
    if (inputFile.openFile(m_filename) == false) {
      System.err.println("Could not open file " + m_filename);
      System.exit(1);
    }

    SoSeparator root = SoDB.readAll(inputFile);
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    // Get the camera from the viewer, and attach a
    // field sensor to its position field:
    SoCamera camera = myViewer.getRenderArea().getRootSceneGraph().getCamera();
    m_fieldSensor = new SoFieldSensor(new CameraChangedRunnable(camera));
    m_fieldSensor.attach(camera.position);

    m_txtArea.setEditable(false);
    JScrollPane jsp = new JScrollPane(m_txtArea);
    jsp.setPreferredSize(new Dimension(400, 400));

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(jsp, BorderLayout.EAST);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  class CameraChangedRunnable implements Runnable {

    SoCamera m_cam;

    public CameraChangedRunnable(SoCamera cam) {
      m_cam = cam;
    }

    @Override
    public void run() {
      SbVec3f cameraPosition = m_cam.position.getValue();
      m_txtArea.append("Camera position: ("+cameraPosition.getX()+","
                 +cameraPosition.getY()+","+cameraPosition.getZ()+")\n");
    }
  }
}
