/*-----------------------------------------------------------
 *  This is an example from The Inventor Mentor,
 *  chapter 9, example 5.
 *
 *  Using a callback for generated primitives.
 *  A simple scene with a sphere is created.
 *  A callback is used to write out the triangles that
 *  form the sphere in the scene.
 *----------------------------------------------------------*/

package inventor.mentor.genSphere; import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoPrimitiveVertex;
import com.openinventor.inventor.actions.SoCallbackAction;
import com.openinventor.inventor.misc.callbacks.SoCallbackActionCB;
import com.openinventor.inventor.misc.callbacks.SoTriangleCB;
import com.openinventor.inventor.nodes.SoDirectionalLight;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoPerspectiveCamera;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSphere;

import util.Example;


public class Main extends Example {

  JTextArea m_txtArea = new JTextArea();

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Spheres generation");
  }

  @Override
  public void start() {
    // Make a scene containing a red sphere
    SoPerspectiveCamera myCamera = new SoPerspectiveCamera();
    SoMaterial myMaterial = new SoMaterial();
    myMaterial.diffuseColor.setValue(1.0f, 0.0f, 0.0f);   // Red

    SoSeparator root = new SoSeparator();
    { // Assemble scene graph
      root.addChild(myCamera);
      root.addChild(new SoDirectionalLight());
      root.addChild(myMaterial);
      root.addChild(new SoSphere());
    }

    // Write out the triangles that form the sphere in the scene
    printSpheres(root);

    m_txtArea.setEditable(false);
    JScrollPane jsp = new JScrollPane(m_txtArea);
    jsp.setPreferredSize(new Dimension(600, 700));

    setLayout(new BorderLayout());
    add(jsp);
  }

  @Override
  public void stop()
  {}

  //////////////////////////////////////////////////////////////
  // CODE FOR The Inventor Mentor STARTS HERE

  private void printSpheres(SoNode root) {
    SoCallbackAction myAction = new SoCallbackAction();
    myAction.addPreCallback(SoSphere.class, new PrintHeaderCallback(), null);
    myAction.addTriangleCallback(SoSphere.class, new PrintTriangleCallback(), null);
    myAction.apply(root);
  }

  class PrintHeaderCallback extends SoCallbackActionCB {
    @Override
    public int invoke(SoCallbackAction s, SoNode node) {
      String str = "Sphere ";

      // Print the node name (if it exists) and address
      if (node.getName().length() != 0)
        str += "named " + node.getName() + " ";
      m_txtArea.append(str + "\n");
//
      return SoCallbackAction.Responses.CONTINUE.getValue();
    }
  }

  class PrintTriangleCallback extends SoTriangleCB {
    @Override
    public void invoke(SoCallbackAction s, SoPrimitiveVertex v1,
                       SoPrimitiveVertex v2, SoPrimitiveVertex v3) {
      m_txtArea.append("Triangle:\n");
      printVertex(v1);
      printVertex(v2);
      printVertex(v3);
    }

    private void printVertex(SoPrimitiveVertex vertex) {
      SbVec3f point = vertex.getPoint();
      m_txtArea.append("\tCoords     = (" + point.getX() + ", " +
                         point.getY() + ", " +
                         point.getZ() + ")\n");

      SbVec3f normal = vertex.getNormal();
      m_txtArea.append("\tNormal     = (" + normal.getX() + ", " +
                         normal.getY() + ", " +
                         normal.getZ() + ")\n");
    }
  }

  // CODE FOR The Inventor Mentor ENDS HERE
  ///////////////////////////////////////////////////////////////

}
