/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor
 *  chapter 13, example 2.
 *
 *  Global fields.
 *  A digital clock is implemented by connecting the realTime
 *  global field to a Text3 string.
 *------------------------------------------------------------*/

package inventor.mentor.globalFields;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoText3;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaInteractive;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example {

  private IRenderAreaInteractive myRenderArea;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Date & Time");
  }

  @Override
  public void start() {
    myRenderArea = ViewerComponentsFactory.createRenderAreaInteractive();

    // Add a material
    SoMaterial myMaterial = new SoMaterial();
    myMaterial.diffuseColor.setValue(1.0f, 0.0f, 0.0f);

    // Create a Text3 object, and connect to the realTime field
    SoText3 myText = new SoText3();
    myText.string.connectFrom(SoDB.getGlobalField("realTime"));

    SoSeparator root = new SoSeparator();
    { // Assemble scene graph
      root.addChild(myMaterial);
      root.addChild(myText);
    }

    final Component canvas = myRenderArea.getComponent();
    myRenderArea.setSceneGraph(root);
    myRenderArea.viewAll(new SbViewportRegion(canvas.getSize()));

    canvas.setPreferredSize(new java.awt.Dimension(400, 400));
    setLayout(new BorderLayout());
    add(canvas);
  }

  @Override
  public void stop()
  {
    myRenderArea.dispose();
  }
}
