package inventor.mentor.helloCone;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
  * Draws a red cone in a window.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer m_myViewer;

  @Override
  public void start()
  {
    m_myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Make a scene containing a red cone
    SoMaterial myMaterial = new SoMaterial();
    myMaterial.diffuseColor.setValue(1.0f, 0.0f, 0.0f);

    SoSeparator root = new SoSeparator();
    { // assemble scene graph
      root.addChild(myMaterial);
      root.addChild(new SoCone());
    }

    m_myViewer.setSceneGraph(root);
    // Make myCamera see everything.
    m_myViewer.viewAll();

    final Component component = m_myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    m_myViewer.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Hello Cone");
  }
}

