package inventor.mentor.highlight;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.actions.SoBoxHighlightRenderAction;
import com.openinventor.inventor.actions.SoSearchAction;
import com.openinventor.inventor.misc.callbacks.SoSelectionClassCB;
import com.openinventor.inventor.nodes.* ;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;


/**
  * mentor.Hightlight example program. Highlights (with a bounding box) the head of a
  * robot. This is a simple example showing how to highlight an object. However,
  * see the AWTList example for further explanations. Particularly, the Highlight example
  * does not use the <B>redrawOnSelectionChange</B> method from a SwRenderArea. It
  * also does not use any selection callback.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */

public class Main extends Example {

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("HighLight");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoSelection selectionRoot = new SoSelection() ;

    // This function contains our code fragment.
    selectionRoot.addChild(makeRobot()) ;
    selectionRoot.addChangeCallback(new SoSelectionClassCB()
    {
      @Override
      public void invoke(SoSelection s)
      {
        myViewer.getRenderArea().scheduleRedraw();
      }
    });

    // highlight with boundingbox
    myViewer.getRenderArea().setGLRenderAction(new SoBoxHighlightRenderAction());
    myViewer.setSceneGraph(selectionRoot);

    // initialize node search
    SoSearchAction search = new SoSearchAction() ;
    search.setName("head") ;
    search.apply(selectionRoot) ;

    // select path to node with name "head"
    selectionRoot.select(search.getPath()) ;

    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  SoSeparator makeRobot() {
    // Robot with legs

    // Construct parts for legs (thigh, calf and foot)
    SoCube thigh = new SoCube() ;
    thigh.width.setValue(1.2F) ;
    thigh.height.setValue(2.2F) ;
    thigh.depth.setValue(1.1F) ;

    SoTransform calfTransform = new SoTransform() ;
    calfTransform.translation.setValue(0, -2.25F, 0);

    SoCube calf = new SoCube() ;
    calf.width.setValue(1) ;
    calf.height.setValue(2.2F) ;
    calf.depth.setValue(1) ;

    SoTransform footTransform = new SoTransform() ;
    footTransform.translation.setValue(0, -1.5F, .5F) ;

    SoCube foot = new SoCube() ;
    foot.setName("foot") ;
    foot.width.setValue(0.8F) ;
    foot.height.setValue(0.8F) ;
    foot.depth.setValue(2) ;

    // Put leg parts together
    SoGroup leg = new SoGroup() ;
    {
      leg.addChild(thigh);
      leg.addChild(calfTransform);
      leg.addChild(calf);
      leg.addChild(footTransform);
      leg.addChild(foot);
    }

    SoTransform leftTransform = new SoTransform() ;
    leftTransform.translation.setValue(new SbVec3f(1, -4.25F, 0)) ;

    // Left leg
    SoSeparator leftLeg = new SoSeparator() ;
    {
      leftLeg.addChild(leftTransform);
      leftLeg.addChild(leg);
    }

    SoTransform rightTransform = new SoTransform() ;
    rightTransform.translation.setValue(-1, -4.25F, 0) ;

    // Right leg
    SoSeparator rightLeg = new SoSeparator() ;
    {
      rightLeg.addChild(rightTransform);
      rightLeg.addChild(leg);
    }

    // Parts for body
    SoTransform bodyTransform = new SoTransform() ;
    bodyTransform.translation.setValue(0.0F, 3.0F, 0.0F) ;

    SoMaterial bronze = new SoMaterial() ;
    bronze.ambientColor.setValue(.33F, .22F, .27F) ;
    bronze.diffuseColor.setValue(.78F, .57F, .11F) ;
    bronze.specularColor.setValue(.99F, .94F, .81F) ;
    bronze.shininess.setValue(.28F) ;

    SoCylinder bodyCylinder = new SoCylinder() ;
    bodyCylinder.setName("body") ;
    bodyCylinder.radius.setValue(2.5F) ;
    bodyCylinder.height.setValue(6) ;

    // Construct body out of parts
    SoSeparator body = new SoSeparator() ;
    {
      body.addChild(bodyTransform);
      body.addChild(bronze);
      body.addChild(bodyCylinder);
      body.addChild(leftLeg);
      body.addChild(rightLeg);
    }

    // Head parts
    SoTransform headTransform = new SoTransform() ;
    headTransform.translation.setValue(0, 7.5F, 0) ;
    headTransform.scaleFactor.setValue(1.5F, 1.5F, 1.5F) ;

    SoMaterial silver = new SoMaterial() ;
    silver.ambientColor.setValue(.2F, .2F, .2F) ;
    silver.diffuseColor.setValue(.6F, .6F, .6F) ;
    silver.specularColor.setValue(.5F, .5F, .5F) ;
    silver.shininess.setValue(.5F) ;

    SoSphere headSphere = new SoSphere() ;
    headSphere.setName("head") ;

    // Construct head
    SoSeparator head = new SoSeparator() ;
    {
      head.addChild(headTransform);
      head.addChild(silver);
      head.addChild(headSphere);
    }

    // Robot is just head and body
    SoSeparator robot = new SoSeparator() ;
    {
      robot.addChild(body);
      robot.addChild(head);
    }

    return robot;
  }
}
