/*-----------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 11, example 1.
 *
 *  Example of reading from a file.
 *  Read a file given a filename and return a separator
 *  containing all of the file.  Return NULL if there is
 *  an error reading the file.
 *----------------------------------------------------------*/

package inventor.mentor.readFile;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("File Reader");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Read the file
    SoSeparator scene = readFile("$OIVJHOME/data/models/plant.iv");

    if (scene == null)
      System.exit(1);

    myViewer.setSceneGraph(scene);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  /////////////////////////////////////////////////////////////
  // CODE FOR The Inventor Mentor STARTS HERE

  SoSeparator readFile(String filename)
  {
    // Open the input file
    SoInput mySceneInput = new SoInput();
    if (!mySceneInput.openFile(filename)) {
      System.err.println("Cannot open file " + filename);
      return null;
    }

    // Read the whole file into the database
    SoSeparator myGraph = SoDB.readAll(mySceneInput);
    if (myGraph == null) {
      System.err.println("Problem reading file");
      return null;
    }

    mySceneInput.closeFile();
    return myGraph;
  }

  // CODE FOR The Inventor Mentor ENDS HERE
  /////////////////////////////////////////////////////////////
}
