package inventor.mentor.robot;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoCube;
import com.openinventor.inventor.nodes.SoCylinder;
import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSphere;
import com.openinventor.inventor.nodes.SoTransform;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;
/**
  *  mentor.Robot example program;
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Robot");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = new SoSeparator() ;

    // This function contains our code fragment.
    root.addChild(makeRobot()) ;

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  SoSeparator makeRobot() {
    // Robot with legs

    // Construct parts for legs (thigh, calf and foot)
    SoCube thigh = new SoCube() ;
    thigh.width.setValue(1.2F) ;
    thigh.height.setValue(2.2F) ;
    thigh.depth.setValue(1.1F) ;

    SoTransform calfTransform = new SoTransform() ;
    calfTransform.translation.setValue(0, -2.25F, 0);

    SoCube calf = new SoCube() ;
    calf.width.setValue(1) ;
    calf.height.setValue(2.2F) ;
    calf.depth.setValue(1) ;

    SoTransform footTransform = new SoTransform() ;
    footTransform.translation.setValue(0, -1.5F, .5F) ;

    SoCube foot = new SoCube() ;
    foot.width.setValue(0.8F) ;
    foot.height.setValue(0.8F) ;
    foot.depth.setValue(2) ;

    // Put leg parts together
    SoGroup leg = new SoGroup() ;
    leg.addChild(thigh) ;
    leg.addChild(calfTransform) ;
    leg.addChild(calf) ;
    leg.addChild(footTransform) ;
    leg.addChild(foot) ;

    SoTransform leftTransform = new SoTransform() ;
    leftTransform.translation.setValue(new SbVec3f(1, -4.25F, 0)) ;

    // Left leg
    SoSeparator leftLeg = new SoSeparator() ;
    leftLeg.addChild(leftTransform) ;
    leftLeg.addChild(leg) ;

    SoTransform rightTransform = new SoTransform() ;
    rightTransform.translation.setValue(-1, -4.25F, 0) ;

    // Right leg
    SoSeparator rightLeg = new SoSeparator() ;
    rightLeg.addChild(rightTransform);
    rightLeg.addChild(leg);

    // Parts for body
    SoTransform bodyTransform = new SoTransform() ;
    bodyTransform.translation.setValue(0.0F, 3.0F, 0.0F) ;

    SoMaterial bronze = new SoMaterial() ;
    bronze.ambientColor.setValue(.33F, .22F, .27F) ;
    bronze.diffuseColor.setValue(.78F, .57F, .11F) ;
    bronze.specularColor.setValue(.99F, .94F, .81F) ;
    bronze.shininess.setValue(.28F) ;

    SoCylinder bodyCylinder = new SoCylinder() ;
    bodyCylinder.radius.setValue(2.5F) ;
    bodyCylinder.height.setValue(6) ;

    // Construct body out of parts
    SoSeparator body = new SoSeparator() ;
    body.addChild(bodyTransform) ;
    body.addChild(bronze) ;
    body.addChild(bodyCylinder) ;
    body.addChild(leftLeg) ;
    body.addChild(rightLeg) ;

    // Head parts
    SoTransform headTransform = new SoTransform() ;
    headTransform.translation.setValue(0, 7.5F, 0) ;
    headTransform.scaleFactor.setValue(1.5F, 1.5F, 1.5F) ;

    SoMaterial silver = new SoMaterial() ;
    silver.ambientColor.setValue(.2F, .2F, .2F) ;
    silver.diffuseColor.setValue(.6F, .6F, .6F) ;
    silver.specularColor.setValue(.5F, .5F, .5F) ;
    silver.shininess.setValue(.5F) ;

    SoSphere headSphere = new SoSphere() ;

    // Construct head
    SoSeparator head = new SoSeparator() ;
    head.addChild(headTransform) ;
    head.addChild(silver) ;
    head.addChild(headSphere) ;

    // Robot is just head and body
    SoSeparator robot = new SoSeparator() ;
    robot.addChild(body) ;
    robot.addChild(head) ;

    return robot;
  }
}
