package inventor.mentor.rotor;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoRotor;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = new SoSeparator();

    // Read in the data for the windmill tower
    root.addChild(readSceneGraph("$OIVJHOME/data/models/windmillTower.iv"));

    // Add a rotor node to spin the vanes
    SoRotor myRotor = new SoRotor();
    myRotor.rotation.setValue(new SbVec3f(0.0f, 0.0f, 1.0f), (float) (Math.PI / 32.0f)); // z
    myRotor.speed.setValue(0.1f);
    root.addChild(myRotor);

    // Read in the data for the windmill vanes
    root.addChild(readSceneGraph("$OIVJHOME/data/models/windmillVanes.iv"));

    // Show the viewer
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  private static SoSeparator readSceneGraph(String fileName)
  {
    SoInput input = new SoInput();

    if ( !input.openFile(fileName) )
    {
      System.err.println("Cannot open file " + fileName);
      return null;
    }

    SoSeparator node = SoDB.readAll(input);
    if ( node == null )
    {
      System.err.println("Problem reading file");
      input.closeFile();
      return null;
    }

    input.closeFile();
    return node;
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Windmill");
  }
}
