package inventor.mentor.simple3DText;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.* ;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
  * This is an example from the Inventor Mentor,
  * chapter 6, example 2.
  *
  * This example renders a globe and uses 3D text to label the
  * continents Africa and Asia.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Simple 3D Text");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Choose a font
    SoFont myFont = new SoFont();
    myFont.name.setValue("Times-Roman");
    myFont.size.setValue(.2F);

    // We'll color the front of the text white, and the sides
    // dark grey. So use a materialBinding of PER_PART and
    // two diffuseColor values in the material node.
    SoMaterial myMaterial = new SoMaterial();
    SoMaterialBinding myBinding = new SoMaterialBinding();
    myMaterial.diffuseColor.set1Value(0,new SbColor(1,1,1));
    myMaterial.diffuseColor.set1Value(1,new SbColor(.1F,.1F,.1F));
    myBinding.value.setValue(SoMaterialBinding.Bindings.PER_PART);

    // Add the globe, a sphere with a texture map.
    // Put it within a separator.
    SoSeparator sphereSep = new SoSeparator();
    SoTexture2 myTexture2 = new SoTexture2();
    SoComplexity sphereComplexity = new SoComplexity();
    sphereComplexity.value.setValue(0.55F);
    {
      sphereSep.addChild(myTexture2);
      sphereSep.addChild(sphereComplexity);
      sphereSep.addChild(new SoSphere());
    }

    myTexture2.filename.setValue("$OIVJHOME/data/textures/rgb/globe.rgb");

    // Add Text3 for AFRICA, transformed to proper location.
    SoSeparator africaSep = new SoSeparator();
    SoTransform africaTransform = new SoTransform();
    SoText3 africaText = new SoText3();
    africaTransform.rotation.setValue(new SbVec3f(0.0F,1.0F,0.0F),.4F);
    africaTransform.translation.setValue(.25F,0F,1.25F);
    africaText.parts.setValue(SoText3.PartType.ALL);
    africaText.string.setValue("AFRICA");
    {
      africaSep.addChild(africaTransform);
      africaSep.addChild(africaText);
    }

    // Add Text3 for ASIA, transformed to proper location.
    SoSeparator asiaSep = new SoSeparator();
    SoTransform asiaTransform = new SoTransform();
    SoText3 asiaText = new SoText3();
    asiaTransform.rotation.setValue(new SbVec3f(0.0F,1.0F,0.0F),1.5F);
    asiaTransform.translation.setValue(.8F,.6F,.5F);
    asiaText.parts.setValue(SoText3.PartType.ALL);
    asiaText.string.setValue("ASIA");
    {
      asiaSep.addChild(asiaTransform);
      asiaSep.addChild(asiaText);
    }

    SoGroup root = new SoGroup();
    { // assemble scene graph
      root.addChild(myFont);
      root.addChild(myMaterial);
      root.addChild(myBinding);
      root.addChild(sphereSep);
      root.addChild(africaSep);
      root.addChild(asiaSep);
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setName("3D Text");
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
