/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor
 *  chapter 7, example 2.
 *
 *  This example illustrates using texture coordindates on
 *  a Face Set.
 *------------------------------------------------------------*/

package inventor.mentor.textureCoordinates;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoFaceSet;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoTexture2;
import com.openinventor.inventor.nodes.SoVertexProperty;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Texture Coordinates");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Choose a texture
    SoTexture2 brick = new SoTexture2();
    brick.filename.setValue("$OIVJHOME/data/textures/rgb/brick.1.rgb");

    SoVertexProperty myVertexProperty = new SoVertexProperty();

    // Define the square's spatial coordinates
    myVertexProperty.vertex.set1Value(0, new SbVec3f(-3, -3, 0));
    myVertexProperty.vertex.set1Value(1, new SbVec3f(3, -3, 0));
    myVertexProperty.vertex.set1Value(2, new SbVec3f(3, 3, 0));
    myVertexProperty.vertex.set1Value(3, new SbVec3f(-3, 3, 0));

    // Define the square's normal
    myVertexProperty.normal.set1Value(0, new SbVec3f(0, 0, 1));

    // Define the square's texture coordinates
    myVertexProperty.texCoord.set1Value(0, new SbVec2f(0, 0));
    myVertexProperty.texCoord.set1Value(1, new SbVec2f(1, 0));
    myVertexProperty.texCoord.set1Value(2, new SbVec2f(1, 1));
    myVertexProperty.texCoord.set1Value(3, new SbVec2f(0, 1));

    // Define normal binding
    myVertexProperty.normalBinding.setValue(SoVertexProperty.Bindings.OVERALL);

    // Define a FaceSet
    SoFaceSet myFaceSet = new SoFaceSet();
    myFaceSet.numVertices.set1Value(0, 4);

    myFaceSet.vertexProperty.setValue(myVertexProperty);

    SoSeparator root = new SoSeparator();
    { // Assemble scene graph
      root.addChild(brick);
      root.addChild(myFaceSet);
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
