package inventor.mentor.textureFunctions;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSphere;
import com.openinventor.inventor.nodes.SoTexture2;
import com.openinventor.inventor.nodes.SoTexture2Transform;
import com.openinventor.inventor.nodes.SoTextureCoordinatePlane;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Texture Functions");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Choose a texture.
    SoTexture2 faceTexture = new SoTexture2();
    faceTexture.filename.setValue("$OIVJHOME/data/textures/rgb/sillyFace.rgb");

    // Make the diffuse color pure white
    SoMaterial myMaterial = new SoMaterial();
    myMaterial.diffuseColor.setValue(1,1,1);

    // This texture2Transform centers the texture about (0,0,0)
    SoTexture2Transform myTexXf = new SoTexture2Transform();
    myTexXf.translation.setValue(.5f,.5f);

    // Define a texture coordinate plane node.  This one will
    // repeat with a frequency of two times per unit length.
    // Add a sphere for it to affect.
    SoTextureCoordinatePlane texPlane1 = new SoTextureCoordinatePlane();
    texPlane1.directionS.setValue(new SbVec3f(2,0,0));
    texPlane1.directionT.setValue(new SbVec3f(0,2,0));

    // A translation node for spacing the three spheres.
    SoTranslation myTranslation = new SoTranslation();
    myTranslation.translation.setValue(2.5f,0,0);

    // Create a second sphere with a repeat frequency of 1.
    SoTextureCoordinatePlane texPlane2 = new SoTextureCoordinatePlane();
    texPlane2.directionS.setValue(new SbVec3f(1,0,0));
    texPlane2.directionT.setValue(new SbVec3f(0,1,0));

    // The third sphere has a repeat frequency of .5
    SoTextureCoordinatePlane texPlane3 = new SoTextureCoordinatePlane();
    texPlane3.directionS.setValue(new SbVec3f(.5f,0,0));
    texPlane3.directionT.setValue(new SbVec3f(0,.5f,0));

    SoSeparator root = new SoSeparator();
    { // Assemble scene graph
       root.addChild(faceTexture);
       root.addChild(myMaterial);
       root.addChild(myTexXf);
       root.addChild(texPlane1);
       root.addChild(new SoSphere());
       root.addChild(myTranslation);
       root.addChild(texPlane2);
       root.addChild(new SoSphere());
       root.addChild(myTranslation);
       root.addChild(texPlane3);
       root.addChild(new SoSphere());
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
