package inventor.mentor.triangleStripSet;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoShapeHints;
import com.openinventor.inventor.nodes.SoTriangleStripSet;
import com.openinventor.inventor.nodes.SoVertexProperty;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
  * This is an example from the Inventor Mentor,
  * chapter 5, example 3.
  *
  * This example creates a TriangleStripSet. It creates
  * a pennant-shaped flag.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{
  //////////////////////////////////////////////////////////////
  // CODE FOR The Inventor Mentor STARTS HERE

  //
  // Positions of all of the vertices:
  //
  static float vertexPositions[][] = {
    {  0F,   12F,    0F }, {   0F,   15F,    0F},
    {2.1F, 12.1F,  -.2F }, { 2.1F, 14.6F,  -.2F},
    {  4F, 12.5F,  -.7F }, {   4F, 14.5F,  -.7F},
    {4.5F, 12.6F,  -.8F }, { 4.5F, 14.4F,  -.8F},
    {  5F, 12.7F,   -1F }, {   5F, 14.4F,   -1F},
    {4.5F, 12.8F, -1.4F }, { 4.5F, 14.6F, -1.4F},
    {  4F, 12.9F, -1.6F }, {   4F, 14.8F, -1.6F},
    {3.3F, 12.9F, -1.8F }, { 3.3F, 14.9F, -1.8F},
    {  3F,   13F, -2.0F }, {   3F, 14.9F, -2.0F},
    {3.3F, 13.1F, -2.2F }, { 3.3F, 15.0F, -2.2F},
    {  4F, 13.2F, -2.5F }, {   4F, 15.0F, -2.5F},
    {  6F, 13.5F, -2.2F }, {   6F, 14.8F, -2.2F},
    {  8F, 13.4F,   -2F }, {   8F, 14.6F,   -2F},
    { 10F, 13.7F, -1.8F }, {  10F, 14.4F, -1.8F},
    { 12F,   14F, -1.3F }, {  12F, 14.5F, -1.3F},
    { 15F, 14.9F, -1.2F }, {  15F,   15F, -1.2F},

    {-.5F, 15F,   0F }, { -.5F, 0F,   0F},   // the flagpole
    {  0F, 15F,  .5F }, {   0F, 0F,  .5F},
    {  0F, 15F, -.5F }, {   0F, 0F, -.5F},
    {-.5F, 15F,   0F }, { -.5F, 0F,   0F}
  };


  // Number of vertices in each strip.
  static int numVertices[] = {
    32, // flag
    8   // pole
  };

  // Colors for the 12 faces
  static float colors[][] = {
    { .5F, .5F,  1F }, // purple flag
    { .4F, .4F, .4F }, // grey flagpole
  };

  private IViewerExaminer myViewer;

  // Routine to create a scene graph representing a pennant.
  SoSeparator makePennant() {
    SoSeparator result = new SoSeparator();

    // A shape hints tells the ordering of polygons.
    // This insures double sided lighting.
    SoShapeHints myHints = new SoShapeHints();
    myHints.vertexOrdering.setValue(SoShapeHints.VertexOrderings.COUNTERCLOCKWISE);
    result.addChild(myHints);

    // This is the preferred code for Inventor 2.1
    // otherwise, see below the commented block

    // Using the new SoVertexProperty node is more efficient
    SoVertexProperty myVertexProperty = new SoVertexProperty();

    // Define colors for the strips
    for (int i=0 ; i<2 ; i++)
      myVertexProperty.orderedRGBA.set1Value(i, new SbColor(colors[i]).getPackedValue());
    myVertexProperty.materialBinding.setValue(SoVertexProperty.Bindings.PER_PART);

    // Define coordinates for vertices
    myVertexProperty.vertex.setValues(0, vertexPositions);

    // Define the TriangleStripSet, made of two strips.
    SoTriangleStripSet myStrips = new SoTriangleStripSet();
    myStrips.numVertices.setValues(0, numVertices);

    myStrips.vertexProperty.setValue(myVertexProperty);
    result.addChild(myStrips);

    /* If you prefer use this style : (not recommended)
       // Define colors for the strips
       SoMaterial myMaterials = new SoMaterial();
       myMaterials.diffuseColor.setValues(0, colors);
       result.addChild(myMaterials);
       SoMaterialBinding myMaterialBinding = new SoMaterialBinding();
       myMaterialBinding.value.setValue(SoMaterialBinding.PER_PART);
       result.addChild(myMaterialBinding);

       // Define coordinates for vertices
       SoCoordinate3 myCoords = new SoCoordinate3();
       myCoords.point.setValues(0, vertexPositions);
       result.addChild(myCoords);

       // Define the TriangleStripSet, made of two strips.
       SoTriangleStripSet myStrips = new SoTriangleStripSet();
       myStrips.numVertices.setValues(0, numVertices);
       result.addChild(myStrips);
    */

    return result;
  }


  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = makePennant();

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setName("Triangle Strip Set: Pennant");
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Triangle Strip Set");
  }
}

