package inventor.sample.bevelAction;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.actions.SoBevelAction;
import com.openinventor.inventor.actions.SoWriteAction;
import com.openinventor.inventor.nodes.SoBevelProperty;
import com.openinventor.inventor.nodes.SoComplexity;
import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoNode node = readSceneGraph("$OIVJHOME/data/models/cube.iv");
    SoSeparator root = new SoSeparator();
    root.addChild(node);

    SoSeparator result1 = new SoSeparator();
    SoComplexity myComplexity = new SoComplexity();
    myComplexity.value.setValue(1f);
    result1.addChild(myComplexity);

    SoBevelProperty prop = new SoBevelProperty();
    prop.radius.setValue(0.2f);
    result1.addChild(prop);
    result1.addChild(root);

    SoBevelAction baction = new SoBevelAction();
    baction.apply(result1);
    SoGroup result2 = baction.getSceneGraph();

    myViewer.setSceneGraph(result2);
    myViewer.viewAll();

    SoWriteAction myAction = new SoWriteAction();
    myAction.getOutput().openFile("./bevel.iv");
    myAction.apply(result2);
    myAction.getOutput().closeFile();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  private static SoSeparator readSceneGraph(String fileName)
  {
    SoInput input = new SoInput();

    if ( !input.openFile(fileName) )
    {
      System.err.println("Cannot open file " + fileName);
      return null;
    }

    SoSeparator node = SoDB.readAll(input);
    if ( node == null )
    {
      System.err.println("Problem reading file");
      input.closeFile();
      return null;
    }

    input.closeFile();
    return node;
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Bevel action");
  }
}
