package inventor.sample.callbackNode;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;

import com.openinventor.inventor.elements.SoCacheElement;
import com.openinventor.inventor.nodes.SoCallback;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main (String [] argv)
  {
    Main example = new Main();
    example.demoMain("Callback Node");
  }

  public Main() {}

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Scene graph initialisation ------------------------------------------------

    SoCone scene = new SoCone();
    SoCallback callback = new SoCallback();
    callback.setCallback(
      new SoCallback.CB()
      {
        int numInvoke = 0;
        @Override
        public void invoke(com.openinventor.inventor.actions.SoAction action)
        {
	  numInvoke++;
	  System.out.println("#" + numInvoke + " Callback node invoked with action " + action.getClass().getSimpleName());
	  SoCacheElement.invalidate(action.getState());
        }
      }
    );

    final SoSwitch switchScene = new SoSwitch();
    switchScene.whichChild.setValue(SoSwitch.WhichChild.SO_SWITCH_ALL.getValue());

    final SoSeparator root = new SoSeparator();
    //    root.renderCaching.setValue(SoSeparator.Cachings.OFF);
    //root.boundingBoxCaching.setValue(SoSeparator.Cachings.OFF);

    {
      root.addChild(switchScene);
      {
        switchScene.addChild(callback);
        switchScene.addChild(scene);
      }
    }

    // Set up viewer -------------------------------------------------------------
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    // Setup the control dialog --------------------------------------------------
    final JCheckBox activationCheckBox = new JCheckBox("Active", true);
    activationCheckBox.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {

      }
    });

    final JButton touchButton = new JButton("Touch scene graph");
    touchButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        root.touch();
	if (switchScene.whichChild.getValue() == SoSwitch.WhichChild.SO_SWITCH_NONE.getValue())
          switchScene.whichChild.setValue(SoSwitch.WhichChild.SO_SWITCH_ALL.getValue());
	else
          switchScene.whichChild.setValue(SoSwitch.WhichChild.SO_SWITCH_NONE.getValue());
      }
    });

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(touchButton, BorderLayout.SOUTH);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
